"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
import re

from services.modules.base_module import BaseModule
from services.modules.run_command.command_manager import CommandManager
from services.modules.system.general.general import General


class HostConfiguration(BaseModule):
    """
    hostconfiguration class
    """
    def get_host_configuration_and_port_functions_status(self):
        """
        get host configuration and port functions status
        :return: data as dict
        """
        data = {}
        mst_device = General(self.connection).get_mst_device()
        res = CommandManager.run_command(connection=self.connection, command=f'mlxprivhost -d {mst_device} q')
        if res.rc == 0:
            # output example
            # mlxprivhost -d 03:00.0 q
            # Host configurations
            # -------------------
            # level                         : PRIVILEGED
            #
            # Port functions status:
            # -----------------------
            # disable_rshim                 : FALSE
            # disable_tracer                : FALSE
            # disable_port_owner            : FALSE
            # disable_counter_rd            : FALSE

            match = re.search(r'level\s*:\s*(\S+)', res.output)
            if match:
                data['Host configurations'] = {'level': match.group(1)}

            match = re.findall(r'(disable\S+)\s+:\s*(\S+)', res.output)
            if match:
                data['Port functions status'] = {}
                for info in match:
                    data['Port functions status'].update({info[0]:info[1]})
            if not data:
                res.update_logger_fail_to_parse_output()
        return data
