"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
import logging

logger = logging.getLogger('services_modules')

class CommandResult:
    """
    Command result class
    """
    is_verbose_mode = False

    def __init__(self, std_out, std_err, returncode, command, timeout_expired=False):
        self.__output = std_out
        self.__error = std_err
        self.__rc = returncode
        self.__command = command
        self.__timeout_expired = timeout_expired
        if self.is_verbose_mode and self.__error:
            logger.warning(f'run command: {command} ,failed with error {self.__error}')

    @property
    def output(self):
        return self.__output

    @property
    def error(self):
        return self.__error

    @property
    def rc(self):
        return self.__rc

    @property
    def command(self):
        return self.__command

    @property
    def timeout_expired(self):
        return self.__timeout_expired

    def update_logger_fail_to_parse_output(self):
        logger.warning(f'failed to parse command: {self.__command} output: {self.__output}')