"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
from services.blueman.models.model import Model
from services.modules.system.cpu.cpu import CPU


class CPUInfo:
    """
    CPUInfo class
    """
    @classmethod
    def cpu_info(cls) -> dict:
        """
        cpu info
        :return: dictionary of data
        """
        expected_result_data = {}
        res = CPU(Model.connection).get_cpu_info()
        expected_data = ['Architecture','BogoMIPS','Byte Order','CPU(s)','Core(s) per socket','Model name',
                         'NUMA node(s)','On-line CPU(s) list','Thread(s) per core','Vendor ID']

        for data_key in res.keys():
            if data_key in expected_data:
                expected_result_data[data_key] = res.get(data_key)

        return expected_result_data