"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
from services.blueman.models.model import Model
from services.modules.netdevice.interface import Interface


class Ports:
    """
    Ports class
    """
    @classmethod
    def get_ports_status(cls):
        """
        get ports status
        :return: list of data
        """
        ports_status_data:list = []
        result = Interface(Model.connection).get_physical_interfaces_info()
        if result:
            for interface_data_dict in result:
                for interface_data in interface_data_dict.values():
                    port_info:dict = {}
                    interface_name = interface_data.get('INTERFACE')
                    if not interface_name:
                        break
                    port_info['Interface Name'] = interface_name
                    port_info['IPv4'] = ''
                    port_info['IPv6'] = ''
                    ipv4s = interface_data.get('IPv4',{})
                    for ip in ipv4s.keys():
                        port_info['IPv4'] = ip
                    ipvs = interface_data.get('IPv6',{})
                    for ip in ipvs.keys():
                        port_info['IPv6'] = ip
                    port_info['Mac Address'] = interface_data.get('MAC','')
                    port_info['MTU'] = interface_data.get('MTU','')
                    port_info['Status'] = interface_data.get('STATE','')
                    port_info['Speed'] = interface_data.get('Speed','')
                    port_info['Link_Layer'] = interface_data.get('LINK','')
                    tmp = port_info
                    ports_status_data.append(tmp)

        return ports_status_data