import sys
from collections import OrderedDict

PYTHON_PATHS = [
    '/opt/mellanox/collectx/python/lib/python2.7/site-packages',
    '/usr/lib/python2.7/site-packages',
    '../'
]

for path in PYTHON_PATHS:
    if path not in sys.path:
        sys.path.insert(0, path)

from counter_tracker import CountersReport

reports = OrderedDict()
#reports["rc"] = ["constraint_errors", "relay_errors"]
#reports["ud"] = ["xmit_wait", "error"]
#reports["dc"] = ["maximim_dcr", "minimum_dcr", "num_no_dcrs", "available_dcrs", "dcr_lifo_size", "dc_cacks", "sq_", "errors"]

#reports["temp"] = [ "mlx5_2:1:current_temp"]
reports["all"] = [ "" ]
#reports["mlx5_0"] = [ "mlx5_0" ]
#reports["mlx5_1"] = [ "mlx5_1" ]
#reports["mlx5_2"] = [ "mlx5_2" ]
#reports["mlx5_3"] = [ "mlx5_3" ]
reports["mlx5_4"] = [ "mlx5_4" ]
#reports["mlx5_5"] = [ "mlx5_5" ]

to_skip = [ ":limit", ":size"]    # mr_cache:size_NN:limit and mr_cache:size_NN:size,

def get_desc():
    return """
Analyze counters for job/interval provided.   topnodes=NNN generated 'top n' report
"""

def start(state):
    for rep in list(reports.keys()):
        if rep in state:
            state[rep] = None

def stop(state):

    for rep in list(reports.keys()):
        if rep in state:
            report = state[rep]
            if report:
                report.output_report()

def process_counters(data_per_node, col_to_idx_lookup, state):

    for rep in list(reports.keys()):
        if rep not in state:
            k = "topnodes"
            if k in state:
                show_top_n = state[k]
            else:
                show_top_n = None
            state[rep] = CountersReport(rep, col_to_idx_lookup, reports[rep], state["schemas"], to_skip, show_top_n)
        report = state[rep]
        report.add_data(data_per_node)

    return False, None

def process_events(src, t, event, state):
    return True, None


if __name__ == "__main__":

    col_to_idx = {}
    col_to_idx["rc1"] = 0
    col_to_idx["rc2"] = 1
    col_to_idx["rc3"] = 2
    col_to_idx["ud1"] = 3
    col_to_idx["ud2"] = 4
    col_to_idx["ud3"] = 5
    col_to_idx["dc1"] = 6
    col_to_idx["dc2"] = 7
    col_to_idx["dc3"] = 8

    dpn= {}
    dpn["node1"] = [(10000, [ 10, 20, 30, 40, 50, 60, 70, 80, 90, 100])]
    dpn["node2"] = [(9999, [10, 20, 30, 40, 50, 60, 70, 80, 90, 100])]
    dpn["node3"] = [(29999, [5101, 521, 531, 541, 551, 561, 571, 581, 591, 511])]
    state = {}

    # TBD: add schemas
    #start(state)
    #print process_counters(dpn, col_to_idx, state)

    dpn = {}
    dpn["node1"] = [(110000, [100, 20, 30, 40, 50, 60, 70, 80, 90, 10])]
    dpn["node2"] = [(19999, [100, 20, 30, 40, 50, 60, 70, 80, 90, 10])]
    dpn["node3"] = [(39999, [5100, 520, 530, 540, 550, 560, 570, 580, 590, 510])]

    # TBD: add schemas
    #print process_counters(dpn, col_to_idx, state)
    #stop(state)
