import datetime

globals = {}

def get_desc():
    return """
Track HCA temperature over time
"""


def start(state):
    started = True
    state["last"] = ""



def stop(state):
    stopped = True

def process_counters(data_per_node, col_to_idx_lookup, state):

    temps = [ "mlx5_0:1:current_temp", "mlx5_2:1:current_temp", "mlx5_4:1:current_temp" ]

    # print col_to_idx_lookup
    # u'mlx4_0:1:port_xmit_data', 1: u'mlx4_0:2:port_xmit_data', 2: u'mlx5_0:1:port_xmit_data', 3: u'mlx5_1:1:port_xmit_data', 4: u'mlx5_2:1:port_xmit_data', 5:
    # u'mlx5_3:1:port_xmit_data', 6: u'mlx5_4:1:port_xmit_data', 7: u'mlx5_5:1:port_xmit_data'
    if "nodes_list" not in state:
        state["nodes_list"] = sorted(data_per_node.keys())

    if "temp_data" not in state:

        state["temp_data"] = [col_to_idx_lookup[temps[0]],
                              col_to_idx_lookup[temps[1]],
                              col_to_idx_lookup[temps[2]] ]

    nodes = state["nodes_list"]
    temp_data = state["temp_data"]
    last = state["last"]
    ret = {}
    last_t = None

    if "t" in state:
        temp_threshold = int(state["t"])
    else:
        # default
        temp_threshold = 75

    for n in nodes:

        if n in data_per_node: # do not necessarily need this - it should always exist.
            last_t, v = data_per_node[n]  # use the last one.
            if v:
                for i in range(len(temp_data)):
                    val = v[temp_data[i]]
                    if val and val > temp_threshold:
                        ret[n+"." + temps[i][0:8]] = val

    if len(ret) > 0:
        next = str(ret) + "\n"
        if last == next:
            return False, None

        state["last"] = next
        datestr = datetime.datetime.fromtimestamp(last_t / 1000000).isoformat()
        return True, str(last_t) + "," + datestr + "," + next

    return False, None



if __name__ == "__main__":
    tt = get_desc()
    print(tt)

    state = {}

