/* SPDX-License-Identifier: GPL-2.0-only or BSD-3-Clause */

/*
 * Copyright (c) 2020 NVIDIA Corporation.
 */

#ifndef __GPIO_MLXBF_REGS_H__
#define __GPIO_MLXBF_REGS_H__

#ifdef __ASSEMBLER__
#define _64bit(x) x
#else /* __ASSEMBLER__ */
#define _64bit(x) x ## ULL
#endif /* __ASSEMBLER */

#include <linux/types.h>

#define GPIO_PIN_DIR_I 0x1040

#define GPIO_PIN_DIR_O 0x1048

#define GPIO_PIN_STATE 0x1000

#define GPIO_INT_SETUP 0x0040
#define GPIO_INT_SETUP__LENGTH 0x0001

#define GPIO_INT_SETUP__GBL_ENA_SHIFT 0
#define GPIO_INT_SETUP__GBL_ENA_WIDTH 1
#define GPIO_INT_SETUP__GBL_ENA_RESET_VAL 0
#define GPIO_INT_SETUP__GBL_ENA_RMASK 0x1
#define GPIO_INT_SETUP__GBL_ENA_MASK  0x1

#define GPIO_INT_SETUP__BASE_INT_NUM_SHIFT 48
#define GPIO_INT_SETUP__BASE_INT_NUM_WIDTH 16
#define GPIO_INT_SETUP__BASE_INT_NUM_RMASK 0xffff
#define GPIO_INT_SETUP__BASE_INT_NUM_MASK  _64bit(0xffff000000000000)

#define GPIO_INT_ENA_ASSERT 0x3000
#define GPIO_INT_ENA_ASSERT__LENGTH 0x0001

#define GPIO_INT_ENA_ASSERT__INT_ENA_ASSERT_SHIFT 0
#define GPIO_INT_ENA_ASSERT__INT_ENA_ASSERT_WIDTH 64
#define GPIO_INT_ENA_ASSERT__INT_ENA_ASSERT_RESET_VAL 0
#define GPIO_INT_ENA_ASSERT__INT_ENA_ASSERT_RMASK _64bit(0xffffffffffffffff)
#define GPIO_INT_ENA_ASSERT__INT_ENA_ASSERT_MASK  _64bit(0xffffffffffffffff)

#define GPIO_INT_ENA_DEASSERT 0x3008
#define GPIO_INT_ENA_DEASSERT__LENGTH 0x0001

#define GPIO_INT_ENA_DEASSERT__INT_ENA_DEASSERT_SHIFT 0
#define GPIO_INT_ENA_DEASSERT__INT_ENA_DEASSERT_WIDTH 64
#define GPIO_INT_ENA_DEASSERT__INT_ENA_DEASSERT_RESET_VAL 0
#define GPIO_INT_ENA_DEASSERT__INT_ENA_DEASSERT_RMASK _64bit(0xffffffffffffffff)
#define GPIO_INT_ENA_DEASSERT__INT_ENA_DEASSERT_MASK  _64bit(0xffffffffffffffff)

#define GPIO_SCRATCHPAD 0x0020

#endif /* !defined(__GPIO_MLXBF_REGS_H__) */
