/*
 * Copyright (c) 2018, Mellanox Technologies. All rights reserved.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __CPLD_REGS_H__
#define __CPLD_REGS_H__

#ifdef __KERNEL__
#include <linux/types.h>
#else
#include <stdint.h>
#endif

#define CPLD_REVISION 0x0
#define CPLD_REVISION_MASK 0xf

#define CPLD_POWER_STATUS_0 0x08
#define CPLD_POWER_STATUS_0__12V_PCIE 0x1
#define CPLD_POWER_STATUS_0__12V_ATX 0x2
#define CPLD_POWER_STATUS_0__3P3V 0x4
#define CPLD_POWER_STATUS_0__5V 0x8
#define CPLD_POWER_STATUS_0__VCORE 0x10
#define CPLD_POWER_STATUS_0__2P5V_DDR 0x20
#define CPLD_POWER_STATUS_0__1P2V_DDR 0x80

#define CPLD_POWER_STATUS_1 0x0b
#define CPLD_POWER_STATUS_1__0P6V_DDR0 0x1
#define CPLD_POWER_STATUS_1__0P6V_DDR1 0x2
#define CPLD_POWER_STATUS_1__1P2V_SERDES 0x4
#define CPLD_POWER_STATUS_1__1P8V 0x8
#define CPLD_POWER_STATUS_1__VRD_FAULT 0x10

#endif /* !defined(__CPLD_REGS_H__) */
