#ifndef PKA_TEST_VECTORS_H
#define PKA_TEST_VECTORS_H

#include <stdint.h>

// 0x017705a70302901dceb605a9a10e3006
static uint8_t VALUE[] =
{
    0x01, 0x77, 0x05, 0xa7, 0x03, 0x02, 0x90, 0x1d,
    0xce, 0xb6, 0x05, 0xa9, 0xa1, 0x0e, 0x30, 0x06
};

// 0x0154fd3836af92d0dca57d05341d3053
static uint8_t SUBTRAHEND[] =
{
    0x01, 0x54, 0xfd, 0x38, 0x36, 0xaf, 0x92, 0xd0,
    0xdc, 0xa5, 0x7d, 0x05, 0x34, 0x1d, 0x30, 0x53
};

static uint8_t SUB_RESULT[] =
{
    0x22, 0x08, 0x6e, 0xcc, 0x52, 0xfd, 0x4c, 0xf2,
    0x10, 0x88, 0xa4, 0x6c, 0xf0, 0xff, 0xb3
};

static uint8_t VAL_TO_INVERT[] =
{
    0x05, 0x4a, 0xb3, 0x8c, 0xbd, 0x42, 0xb0
};

static uint8_t INVERT_MODULUS[] =
{
    0x01, 0x54, 0xfd, 0x38, 0x36, 0xaf, 0x92, 0xd0,
    0xdc, 0xa5, 0x7d, 0x05, 0x34, 0x1d, 0x30, 0x53
};

static uint8_t INVERT_RESULT[] =
{
    0xa2, 0xdb, 0x7e, 0x61, 0x58, 0x97, 0x4f, 0x7f,
    0x06, 0xb4, 0x05, 0x07, 0x62, 0xad, 0x76
};


static uint8_t RESULT0[] =
{
    0x01, [1 ... 204] = 0x0
};

static uint8_t RESULT1[] =
{
    0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFF
};

static uint8_t RESULT2[] =
{
    0x38, 0xC2, 0xEC, 0xF6, 0x50, 0xA2, 0x05, 0x85,
    0x21, 0x77, 0x7D, 0x1F, 0x41, 0xC7, 0xF7, 0x22,
    0xAD, 0x15, 0xF9, 0xAD, 0x36, 0x33, 0xC6, 0x72,
    0x65, 0xCE, 0x37, 0x0D, 0x3A, 0x79, 0x5A, 0xDF,
    0x9A, 0x30, 0x88, 0xF9, 0xD2, 0xD2, 0x12, 0xCE,
    0xF8, 0x38, 0x88, 0xCF, 0xBB, 0x03, 0xA1, 0x75,
    0x51, 0x2D, 0x29, 0x5A, 0x02, 0xCC, 0xC9, 0x73,
    0xC3, 0xF5, 0xEB, 0x60, 0x00, 0x4E, 0xDF, 0x60,
    0xD5, 0x3E, 0xF0, 0x33, 0x30, 0x8A, 0xBA, 0xE2,
    0x4D, 0x04, 0xD8, 0xB6, 0xFE, 0xE6, 0xD7, 0x3A,
    0xD0, 0x9C, 0xF5, 0x10, 0x31, 0x19, 0x12, 0x1C,
    0xC2, 0x91, 0x69, 0x5A, 0xEA, 0xC7, 0x7B, 0x0F,
    0x57, 0x0A, 0xEB, 0x79, 0x1E, 0x82, 0x3C, 0x16
};

static uint8_t RESULT3[] =
{
    0x01, [1 ... 100] = 0x0
};

static uint8_t RESULT4[] =
{
    0x89, 0x95, 0XCD, 0XED, 0x47, 0XC2, 0XD8, 0XAB,
    0XDB, 0XEC, 0X2E, 0XE2, 0x62, 0X2C, 0x98, 0x61,
    0x51, 0x25, 0X6B, 0x10, 0XBF, 0X1B, 0X9F, 0XFE,
    0XF6, 0x17, 0x25, 0XC8, 0XAF, 0X5F, 0XAA, 0x43,
    0XB1, 0x69, 0X7C, 0x07, 0X6E, 0x05, 0x96, 0XC6,
    0x98, 0X1B, 0XD6, 0x07, 0X3C, 0x46, 0XFF, 0x59,
    0x63, 0X2D, 0X7B, 0x66, 0X8A, 0XC9, 0X7B, 0X4E,
    0XCD, 0XEC, 0X8A, 0X8E, 0XDB, 0XA2, 0XC2, 0XC2,
    0X5C, 0x83, 0X6E, 0x17, 0XFE, 0x77, 0XC7, 0x01,
    0X1B, 0XE3, 0x08, 0x50, 0x90, 0x87, 0X5D, 0XBA,
    0x75, 0XAF, 0XB5, 0XED, 0x39, 0x43, 0XB6, 0x24,
    0x60, 0XFA, 0XB4, 0XED, 0XA9, 0X3F, 0x72, 0XEA,
    0X8D, 0XB4, 0XE1, 0x08, 0XE3, 0x37, 0X1E, 0x22,
    0x51, 0XC3, 0x19, 0XBD, 0XA8, 0x37, 0x97, 0XB0,
    0XB7, 0x61, 0x73, 0XCC, 0x23, 0x29, 0X2C, 0XBF,
    0X9A, 0X5D, 0x14, 0x00, 0x14, 0x67, 0x58, 0x06,
    0X9C, 0XF1, 0x08, 0x78, 0x17, 0X3F, 0XEC, 0XDF,
    0X0E, 0XF0, 0x84, 0x11, 0XFA, 0x54, 0x37, 0X7C,
    0x50, 0XD6, 0x53, 0x52, 0XAC, 0X5D, 0XA3, 0x73,
    0X8D, 0XCB, 0XBF, 0x67, 0XFB, 0XD4, 0x69, 0XF8,
    0x51, 0X4E, 0XC5, 0X3F, 0XB0, 0X4A, 0XF4, 0x46,
    0X3D, 0x17, 0XDE, 0XF8, 0XF8, 0XE8, 0x36, 0x26,
    0XE2, 0x60, 0XC3, 0x83, 0X4F, 0X2B, 0x89, 0x30,
    0x10, 0XF7, 0X3D, 0x12, 0x58, 0XDD, 0XAA, 0XB9,
    0XD6, 0XB2, 0X5A, 0X3F, 0x78, 0x60, 0X4C, 0X0C,
    0x16, 0X6E, 0X0C, 0X3A
};



// RSA test vectors:
// From ftp://ftp.rsasecurity.com/pub/pkcs/pkcs-1/pkcs-1v2-1-vec.zip, the
// file oaep_int.txt.
static uint8_t RSA1024_modulus[] =
{
    0xbb, 0xf8, 0x2f, 0x09, 0x06, 0x82, 0xce, 0x9c,
    0x23, 0x38, 0xac, 0x2b, 0x9d, 0xa8, 0x71, 0xf7,
    0x36, 0x8d, 0x07, 0xee, 0xd4, 0x10, 0x43, 0xa4,
    0x40, 0xd6, 0xb6, 0xf0, 0x74, 0x54, 0xf5, 0x1f,
    0xb8, 0xdf, 0xba, 0xaf, 0x03, 0x5c, 0x02, 0xab,
    0x61, 0xea, 0x48, 0xce, 0xeb, 0x6f, 0xcd, 0x48,
    0x76, 0xed, 0x52, 0x0d, 0x60, 0xe1, 0xec, 0x46,
    0x19, 0x71, 0x9d, 0x8a, 0x5b, 0x8b, 0x80, 0x7f,
    0xaf, 0xb8, 0xe0, 0xa3, 0xdf, 0xc7, 0x37, 0x72,
    0x3e, 0xe6, 0xb4, 0xb7, 0xd9, 0x3a, 0x25, 0x84,
    0xee, 0x6a, 0x64, 0x9d, 0x06, 0x09, 0x53, 0x74,
    0x88, 0x34, 0xb2, 0x45, 0x45, 0x98, 0x39, 0x4e,
    0xe0, 0xaa, 0xb1, 0x2d, 0x7b, 0x61, 0xa5, 0x1f,
    0x52, 0x7a, 0x9a, 0x41, 0xf6, 0xc1, 0x68, 0x7f,
    0xe2, 0x53, 0x72, 0x98, 0xca, 0x2a, 0x8f, 0x59,
    0x46, 0xf8, 0xe5, 0xfd, 0x09, 0x1d, 0xbd, 0xcb
};

static uint8_t RSA1024_private[] =
{
    0xa5, 0xda, 0xfc, 0x53, 0x41, 0xfa, 0xf2, 0x89,
    0xc4, 0xb9, 0x88, 0xdb, 0x30, 0xc1, 0xcd, 0xf8,
    0x3f, 0x31, 0x25, 0x1e, 0x06, 0x68, 0xb4, 0x27,
    0x84, 0x81, 0x38, 0x01, 0x57, 0x96, 0x41, 0xb2,
    0x94, 0x10, 0xb3, 0xc7, 0x99, 0x8d, 0x6b, 0xc4,
    0x65, 0x74, 0x5e, 0x5c, 0x39, 0x26, 0x69, 0xd6,
    0x87, 0x0d, 0xa2, 0xc0, 0x82, 0xa9, 0x39, 0xe3,
    0x7f, 0xdc, 0xb8, 0x2e, 0xc9, 0x3e, 0xda, 0xc9,
    0x7f, 0xf3, 0xad, 0x59, 0x50, 0xac, 0xcf, 0xbc,
    0x11, 0x1c, 0x76, 0xf1, 0xa9, 0x52, 0x94, 0x44,
    0xe5, 0x6a, 0xaf, 0x68, 0xc5, 0x6c, 0x09, 0x2c,
    0xd3, 0x8d, 0xc3, 0xbe, 0xf5, 0xd2, 0x0a, 0x93,
    0x99, 0x26, 0xed, 0x4f, 0x74, 0xa1, 0x3e, 0xdd,
    0xfb, 0xe1, 0xa1, 0xce, 0xcc, 0x48, 0x94, 0xaf,
    0x94, 0x28, 0xc2, 0xb7, 0xb8, 0x88, 0x3f, 0xe4,
    0x46, 0x3a, 0x4b, 0xc8, 0x5b, 0x1c, 0xb3, 0xc1
};

static uint8_t RSA1024_public[] =
{
    0x11
};

static uint8_t RSA1024_p[] =
{
    0xee, 0xcf, 0xae, 0x81, 0xb1, 0xb9, 0xb3, 0xc9,
    0x08, 0x81, 0x0b, 0x10, 0xa1, 0xb5, 0x60, 0x01,
    0x99, 0xeb, 0x9f, 0x44, 0xae, 0xf4, 0xfd, 0xa4,
    0x93, 0xb8, 0x1a, 0x9e, 0x3d, 0x84, 0xf6, 0x32,
    0x12, 0x4e, 0xf0, 0x23, 0x6e, 0x5d, 0x1e, 0x3b,
    0x7e, 0x28, 0xfa, 0xe7, 0xaa, 0x04, 0x0a, 0x2d,
    0x5b, 0x25, 0x21, 0x76, 0x45, 0x9d, 0x1f, 0x39,
    0x75, 0x41, 0xba, 0x2a, 0x58, 0xfb, 0x65, 0x99
};

static uint8_t RSA1024_q[] =
{
    0xc9, 0x7f, 0xb1, 0xf0, 0x27, 0xf4, 0x53, 0xf6,
    0x34, 0x12, 0x33, 0xea, 0xaa, 0xd1, 0xd9, 0x35,
    0x3f, 0x6c, 0x42, 0xd0, 0x88, 0x66, 0xb1, 0xd0,
    0x5a, 0x0f, 0x20, 0x35, 0x02, 0x8b, 0x9d, 0x86,
    0x98, 0x40, 0xb4, 0x16, 0x66, 0xb4, 0x2e, 0x92,
    0xea, 0x0d, 0xa3, 0xb4, 0x32, 0x04, 0xb5, 0xcf,
    0xce, 0x33, 0x52, 0x52, 0x4d, 0x04, 0x16, 0xa5,
    0xa4, 0x41, 0xe7, 0x00, 0xaf, 0x46, 0x15, 0x03
};

static uint8_t RSA1024_dp[] =   // d mod p
{
    0x54, 0x49, 0x4c, 0xa6, 0x3e, 0xba, 0x03, 0x37,
    0xe4, 0xe2, 0x40, 0x23, 0xfc, 0xd6, 0x9a, 0x5a,
    0xeb, 0x07, 0xdd, 0xdc, 0x01, 0x83, 0xa4, 0xd0,
    0xac, 0x9b, 0x54, 0xb0, 0x51, 0xf2, 0xb1, 0x3e,
    0xd9, 0x49, 0x09, 0x75, 0xea, 0xb7, 0x74, 0x14,
    0xff, 0x59, 0xc1, 0xf7, 0x69, 0x2e, 0x9a, 0x2e,
    0x20, 0x2b, 0x38, 0xfc, 0x91, 0x0a, 0x47, 0x41,
    0x74, 0xad, 0xc9, 0x3c, 0x1f, 0x67, 0xc9, 0x81
};

static uint8_t RSA1024_dq[] =   // d mod q
{
    0x47, 0x1e, 0x02, 0x90, 0xff, 0x0a, 0xf0, 0x75,
    0x03, 0x51, 0xb7, 0xf8, 0x78, 0x86, 0x4c, 0xa9,
    0x61, 0xad, 0xbd, 0x3a, 0x8a, 0x7e, 0x99, 0x1c,
    0x5c, 0x05, 0x56, 0xa9, 0x4c, 0x31, 0x46, 0xa7,
    0xf9, 0x80, 0x3f, 0x8f, 0x6f, 0x8a, 0xe3, 0x42,
    0xe9, 0x31, 0xfd, 0x8a, 0xe4, 0x7a, 0x22, 0x0d,
    0x1b, 0x99, 0xa4, 0x95, 0x84, 0x98, 0x07, 0xfe,
    0x39, 0xf9, 0x24, 0x5a, 0x98, 0x36, 0xda, 0x3d
};

static uint8_t RSA1024_qInv[] =   // q^(-1) mod p
{
    0xb0, 0x6c, 0x4f, 0xda, 0xbb, 0x63, 0x01, 0x19,
    0x8d, 0x26, 0x5b, 0xdb, 0xae, 0x94, 0x23, 0xb3,
    0x80, 0xf2, 0x71, 0xf7, 0x34, 0x53, 0x88, 0x50,
    0x93, 0x07, 0x7f, 0xcd, 0x39, 0xe2, 0x11, 0x9f,
    0xc9, 0x86, 0x32, 0x15, 0x4f, 0x58, 0x83, 0xb1,
    0x67, 0xa9, 0x67, 0xbf, 0x40, 0x2b, 0x4e, 0x9e,
    0x2e, 0x0f, 0x96, 0x56, 0xe6, 0x98, 0xea, 0x36,
    0x66, 0xed, 0xfb, 0x25, 0x79, 0x80, 0x39, 0xf7
};

static uint8_t RSA1024_msg[] =
{
    0x00, 0xeb, 0x7a, 0x19, 0xac, 0xe9, 0xe3, 0x00,
    0x63, 0x50, 0xe3, 0x29, 0x50, 0x4b, 0x45, 0xe2,
    0xca, 0x82, 0x31, 0x0b, 0x26, 0xdc, 0xd8, 0x7d,
    0x5c, 0x68, 0xf1, 0xee, 0xa8, 0xf5, 0x52, 0x67,
    0xc3, 0x1b, 0x2e, 0x8b, 0xb4, 0x25, 0x1f, 0x84,
    0xd7, 0xe0, 0xb2, 0xc0, 0x46, 0x26, 0xf5, 0xaf,
    0xf9, 0x3e, 0xdc, 0xfb, 0x25, 0xc9, 0xc2, 0xb3,
    0xff, 0x8a, 0xe1, 0x0e, 0x83, 0x9a, 0x2d, 0xdb,
    0x4c, 0xdc, 0xfe, 0x4f, 0xf4, 0x77, 0x28, 0xb4,
    0xa1, 0xb7, 0xc1, 0x36, 0x2b, 0xaa, 0xd2, 0x9a,
    0xb4, 0x8d, 0x28, 0x69, 0xd5, 0x02, 0x41, 0x21,
    0x43, 0x58, 0x11, 0x59, 0x1b, 0xe3, 0x92, 0xf9,
    0x82, 0xfb, 0x3e, 0x87, 0xd0, 0x95, 0xae, 0xb4,
    0x04, 0x48, 0xdb, 0x97, 0x2f, 0x3a, 0xc1, 0x4f,
    0x7b, 0xc2, 0x75, 0x19, 0x52, 0x81, 0xce, 0x32,
    0xd2, 0xf1, 0xb7, 0x6d, 0x4d, 0x35, 0x3e, 0x2d
};

static uint8_t RSA1024_result[] =
{
    0x12, 0x53, 0xe0, 0x4d, 0xc0, 0xa5, 0x39, 0x7b,
    0xb4, 0x4a, 0x7a, 0xb8, 0x7e, 0x9b, 0xf2, 0xa0,
    0x39, 0xa3, 0x3d, 0x1e, 0x99, 0x6f, 0xc8, 0x2a,
    0x94, 0xcc, 0xd3, 0x00, 0x74, 0xc9, 0x5d, 0xf7,
    0x63, 0x72, 0x20, 0x17, 0x06, 0x9e, 0x52, 0x68,
    0xda, 0x5d, 0x1c, 0x0b, 0x4f, 0x87, 0x2c, 0xf6,
    0x53, 0xc1, 0x1d, 0xf8, 0x23, 0x14, 0xa6, 0x79,
    0x68, 0xdf, 0xea, 0xe2, 0x8d, 0xef, 0x04, 0xbb,
    0x6d, 0x84, 0xb1, 0xc3, 0x1d, 0x65, 0x4a, 0x19,
    0x70, 0xe5, 0x78, 0x3b, 0xd6, 0xeb, 0x96, 0xa0,
    0x24, 0xc2, 0xca, 0x2f, 0x4a, 0x90, 0xfe, 0x9f,
    0x2e, 0xf5, 0xc9, 0xc1, 0x40, 0xe5, 0xbb, 0x48,
    0xda, 0x95, 0x36, 0xad, 0x87, 0x00, 0xc8, 0x4f,
    0xc9, 0x13, 0x0a, 0xde, 0xa7, 0x4e, 0x55, 0x8d,
    0x51, 0xa7, 0x4d, 0xdf, 0x85, 0xd8, 0xb5, 0x0d,
    0xe9, 0x68, 0x38, 0xd6, 0x06, 0x3e, 0x09, 0x55
};



static uint8_t ECC_RESULT10_x[] =
{
    0x03, 0x1A, 0x5E, 0x56, 0x14, 0x6C, 0xA1, 0x44,
    0x4C, 0xB5, 0x04, 0xE6, 0xB1, 0x81, 0x4F, 0x14,
    0x8B, 0x61, 0xD8, 0xD4, 0xDF, 0xB2, 0x7A, 0x21,
    0x7D, 0x5A, 0x17, 0x78, 0x50, 0x73, 0xC9, 0x4E
};

static uint8_t ECC_RESULT10_y[] =
{
    0x5A, 0x8A, 0x37, 0xED, 0x83, 0xBF, 0x7F, 0xFF,
    0x10, 0xCC, 0x88, 0x25, 0x70, 0x64, 0x70, 0xED,
    0xA0, 0x8B, 0x92, 0x2B, 0xB6, 0x51, 0x56, 0x94,
    0x09, 0x7E, 0x3C, 0x1B, 0xB3, 0xD5, 0xC3, 0xF6
};

static uint8_t ECC_RESULT11_x[] =
{
    0x27, 0x2F, 0xF1, 0x02, 0x61, 0x2A, 0x81, 0x31,
    0x5E, 0x8F, 0x96, 0xC0, 0x1D, 0x79, 0xDA, 0x6E,
    0xB8, 0xC3, 0xFE, 0x7D, 0x50, 0x65, 0xA2, 0x10,
    0xF8, 0xAB, 0x9E, 0x9B, 0x32, 0x78, 0x00, 0x8F
};

static uint8_t ECC_RESULT11_y[] =
{
    0x59, 0x79, 0x44, 0xAA, 0xCE, 0x28, 0x2E, 0x8E,
    0xC2, 0xBE, 0xCB, 0x64, 0x6D, 0xFA, 0xF8, 0x5C,
    0xBE, 0x7D, 0x34, 0x92, 0x5C, 0xE5, 0x8F, 0x09,
    0x00, 0xF5, 0x3D, 0x55, 0x63, 0xA1, 0x3F, 0xB6
};

static uint8_t ECC_RESULT12_x[] =
{
    0x82, 0x0D, 0x30, 0xD1, 0x6E, 0x6D, 0x8A, 0xBA,
    0x1F, 0xA7, 0xE7, 0xB4, 0xAB, 0xB1, 0xBC, 0xFF,
    0x7B, 0x79, 0xB5, 0x20, 0xF6, 0x08, 0x39, 0xCF,
    0x5F, 0x6F, 0x0F, 0xB7, 0xC9, 0x5C, 0x4D, 0x2F
};

static uint8_t ECC_RESULT12_y[] =
{
    0x9F, 0x4E, 0x2A, 0x69, 0x76, 0xED, 0xAB, 0x74,
    0x61, 0x35, 0x62, 0x59, 0xE8, 0x60, 0x86, 0xF0,
    0x81, 0x1E, 0x96, 0x37, 0x9F, 0x08, 0x4D, 0xB0,
    0x6C, 0x13, 0x3A, 0x84, 0x66, 0x9A, 0xE5, 0x79
};

static uint8_t ECC_RESULT13_x[] =
{
    0x2B, 0xFE, 0xFC, 0xC0, 0x8C, 0x7E, 0x07, 0x71,
    0x2D, 0xCD, 0x04, 0x1B, 0x37, 0x16, 0x72, 0xDF,
    0x49, 0x7D, 0xAA, 0xFB, 0xE1, 0xDA, 0x77, 0xDC,
    0x7C, 0x5E, 0xB0, 0xD3, 0x46, 0x07, 0x65, 0x1C
};

static uint8_t ECC_RESULT13_y[] =
{
    0x25, 0xEF, 0xDB, 0xB2, 0xA7, 0x1B, 0x40, 0xEA,
    0x9C, 0x15, 0x0A, 0xF4, 0x07, 0x98, 0x20, 0x5E,
    0x98, 0x04, 0x7E, 0x5F, 0x22, 0xFC, 0x4F, 0x7B,
    0x86, 0x12, 0x03, 0x73, 0x4A, 0xC3, 0x14, 0x4E
};

static uint8_t ECC_RESULT20_x[] =
{
    0xD3, 0xDC, 0x9C, 0x92, 0x17, 0xC7, 0x17, 0x81,
    0xB3, 0x09, 0xEE, 0x16, 0x3E, 0x03, 0xCB, 0x7B,
    0xBF, 0x04, 0xA3, 0xFF, 0x85, 0x20, 0x9F, 0x66,
    0x7E, 0xF6, 0x4C, 0xC6, 0x19, 0xAC, 0x40, 0xD9
};

static uint8_t ECC_RESULT20_y[] =
{
    0xF5, 0xBF, 0xFB, 0x46, 0x51, 0x00, 0x71, 0xE2,
    0x0A, 0x46, 0x94, 0xA9, 0xC5, 0x2A, 0x7E, 0xDD,
    0xAF, 0xE7, 0x95, 0x79, 0x87, 0x3B, 0x96, 0x34,
    0xE4, 0x32, 0xF7, 0xD1, 0x14, 0xCB, 0xB3, 0xAE
};

static uint8_t ECC_RESULT21_x[] =
{
    0x21, 0x0B, 0x58, 0x20, 0xA2, 0x24, 0x8F, 0x80,
    0xCE, 0xE7, 0x4C, 0xAD, 0xC5, 0xDE, 0xF7, 0x90,
    0xE5, 0xEB, 0x68, 0x51, 0xB8, 0xC1, 0x5C, 0xA5,
    0x95, 0xCD, 0x4E, 0x77, 0xE2, 0x4B, 0x99, 0x41
};

static uint8_t ECC_RESULT21_y[] =
{
    0xEA, 0xFA, 0xF4, 0x17, 0xB1, 0x6B, 0x43, 0x72,
    0xB4, 0xD1, 0x4D, 0x4A, 0x81, 0xDA, 0x48, 0x6B,
    0x21, 0x64, 0x6D, 0xD4, 0x83, 0x11, 0xFA, 0xB7,
    0x89, 0x75, 0x91, 0x55, 0xFD, 0x8F, 0x40, 0xE7
};


static uint8_t P256_p[] =
{
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

static uint8_t P256_a[] =
{
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC
};

static uint8_t P256_b[] =
{
    0x5A, 0xC6, 0x35, 0xD8, 0xAA, 0x3A, 0x93, 0xE7,
    0xB3, 0xEB, 0xBD, 0x55, 0x76, 0x98, 0x86, 0xBC,
    0x65, 0x1D, 0x06, 0xB0, 0xCC, 0x53, 0xB0, 0xF6,
    0x3B, 0xCE, 0x3C, 0x3E, 0x27, 0xD2, 0x60, 0x4B
};

// Base_pt:
static uint8_t P256_xg[] =
{
    0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
    0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2,
    0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0,
    0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96
};

static uint8_t P256_yg[] =
{
    0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b,
    0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16,
    0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce,
    0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5
};

// Base_pt_order:
static uint8_t P256_n[] =
{
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
    0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
};

static uint8_t P256_private_key[] =
{
    0XDC, 0x51, 0XD3, 0x86, 0X6A, 0x15, 0XBA, 0XCD,
    0XE3, 0X3D, 0x96, 0XF9, 0x92, 0XFC, 0XA9, 0X9D,
    0XA7, 0XE6, 0XEF, 0x09, 0x34, 0XE7, 0x09, 0x75,
    0x59, 0XC2, 0X7F, 0x16, 0x14, 0XC8, 0X8A, 0X7F
};

static uint8_t P256_public_key_x[] =
{
    0x24, 0x42, 0XA5, 0XCC, 0X0E, 0XCD, 0x01, 0X5F,
    0XA3, 0XCA, 0x31, 0XDC, 0X8E, 0X2B, 0XBC, 0x70,
    0XBF, 0x42, 0XD6, 0X0C, 0XBC, 0XA2, 0x00, 0x85,
    0XE0, 0x82, 0X2C, 0XB0, 0x42, 0x35, 0XE9, 0x70
};

static uint8_t P256_public_key_y[] =
{
    0X6F, 0XC9, 0X8B, 0XD7, 0XE5, 0x02, 0x11, 0XA4,
    0XA2, 0x71, 0x02, 0XFA, 0x35, 0x49, 0XDF, 0x79,
    0XEB, 0XCB, 0X4B, 0XF2, 0x46, 0XB8, 0x09, 0x45,
    0XCD, 0XDF, 0XE7, 0XD5, 0x09, 0XBB, 0XFD, 0X7D
};

static uint8_t P256_hash[] =
{
    0XBA, 0x78, 0x16, 0XBF, 0X8F, 0x01, 0XCF, 0XEA,
    0x41, 0x41, 0x40, 0XDE, 0X5D, 0XAE, 0x22, 0x23,
    0XB0, 0x03, 0x61, 0XA3, 0x96, 0x17, 0X7A, 0X9C,
    0XB4, 0x10, 0XFF, 0x61, 0XF2, 0x00, 0x15, 0XAD
};

static uint8_t P256_k[] =
{
    0X9E, 0x56, 0XF5, 0x09, 0x19, 0x67, 0x84, 0XD9,
    0x63, 0XD1, 0XC0, 0XA4, 0x01, 0x51, 0X0E, 0XE7,
    0XAD, 0XA3, 0XDC, 0XC5, 0XDE, 0XE0, 0X4B, 0x15,
    0X4B, 0XF6, 0X1A, 0XF1, 0XD5, 0XA6, 0XDE, 0XCE
};

static uint8_t P256_r[] =
{
    0XCB, 0x28, 0XE0, 0x99, 0X9B, 0X9C, 0x77, 0x15,
    0XFD, 0X0A, 0x80, 0XD8, 0XE4, 0X7A, 0x77, 0x07,
    0x97, 0x16, 0XCB, 0XBF, 0x91, 0X7D, 0XD7, 0X2E,
    0x97, 0x56, 0X6E, 0XA1, 0XC0, 0x66, 0x95, 0X7C
};

static uint8_t P256_s[] =
{
    0x86, 0XFA, 0X3B, 0XB4, 0XE2, 0X6C, 0XAD, 0X5B,
    0XF9, 0X0B, 0X7F, 0x81, 0x89, 0x92, 0x56, 0XCE,
    0x75, 0x94, 0XBB, 0X1E, 0XA0, 0XC8, 0x92, 0x12,
    0x74, 0X8B, 0XFF, 0X3B, 0X3D, 0X5B, 0x03, 0x15
};



static uint8_t P384_p[] =
{
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF
};

static uint8_t P384_a[] =
{
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFC
};

static uint8_t P384_b[] =
{
    0xB3, 0x31, 0x2F, 0xA7, 0xE2, 0x3E, 0xE7, 0xE4,
    0x98, 0x8E, 0x05, 0x6B, 0xE3, 0xF8, 0x2D, 0x19,
    0x18, 0x1D, 0x9C, 0x6E, 0xFE, 0x81, 0x41, 0x12,
    0x03, 0x14, 0x08, 0x8F, 0x50, 0x13, 0x87, 0x5A,
    0xC6, 0x56, 0x39, 0x8D, 0x8A, 0x2E, 0xD1, 0x9D,
    0x2A, 0x85, 0xC8, 0xED, 0xD3, 0xEC, 0x2A, 0xEF
};

static uint8_t P384_xg[] =
{
    0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37,
    0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74,
    0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,
    0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38,
    0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c,
    0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7
};

static uint8_t P384_yg[] =
{
    0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f,
    0x5d, 0x9e, 0x98, 0xbf, 0x92, 0x92, 0xdc, 0x29,
    0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c,
    0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0,
    0x0a, 0x60, 0xb1, 0xce, 0x1d, 0x7e, 0x81, 0x9d,
    0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f
};

// Base_pt_order:
static uint8_t P384_n[] =
{
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf,
    0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
    0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73
};

static uint8_t P384_private_key[] =
{
    0X0B, 0XEB, 0x64, 0x66, 0x34, 0XBA, 0x87, 0x73,
    0X5D, 0x77, 0XAE, 0x48, 0x09, 0XA0, 0XEB, 0XEA,
    0x86, 0x55, 0x35, 0XDE, 0X4C, 0X1E, 0X1D, 0XCB,
    0x69, 0X2E, 0x84, 0x70, 0X8E, 0x81, 0XA5, 0XAF,
    0x62, 0XE5, 0x28, 0XC3, 0X8B, 0X2A, 0x81, 0XB3,
    0x53, 0x09, 0x66, 0X8D, 0x73, 0x52, 0X4D, 0X9F
};

static uint8_t P384_public_key_x[] =
{
    0x96, 0x28, 0X1B, 0XF8, 0XDD, 0X5E, 0x05, 0x25,
    0XCA, 0x04, 0X9C, 0x04, 0X8D, 0x34, 0X5D, 0x30,
    0x82, 0x96, 0X8D, 0x10, 0XFE, 0XDF, 0X5C, 0X5A,
    0XCA, 0X0C, 0x64, 0XE6, 0x46, 0X5A, 0x97, 0XEA,
    0X5C, 0XE1, 0X0C, 0X9D, 0XFE, 0XC2, 0x17, 0x97,
    0x41, 0x57, 0x10, 0x72, 0X1F, 0x43, 0x79, 0x22
};

static uint8_t P384_public_key_y[] =
{
    0x44, 0x76, 0x88, 0XBA, 0x94, 0x70, 0X8E, 0XB6,
    0XE2, 0XE4, 0XD5, 0X9F, 0X6A, 0XB6, 0XD7, 0XED,
    0XFF, 0x93, 0x01, 0XD2, 0x49, 0XFE, 0x49, 0XC3,
    0x30, 0x96, 0x65, 0X5F, 0X5D, 0x50, 0X2F, 0XAD,
    0X3D, 0x38, 0X3B, 0x91, 0XC5, 0XE7, 0XED, 0XAA,
    0X2B, 0x71, 0X4C, 0XC9, 0X9D, 0x57, 0x43, 0XCA
};

static uint8_t P384_hash[] =
{
    0XCB, 0x00, 0x75, 0X3F, 0x45, 0XA3, 0X5E, 0X8B,
    0XB5, 0XA0, 0X3D, 0x69, 0X9A, 0XC6, 0x50, 0x07,
    0x27, 0X2C, 0x32, 0XAB, 0X0E, 0XDE, 0XD1, 0x63,
    0X1A, 0X8B, 0x60, 0X5A, 0x43, 0XFF, 0X5B, 0XED,
    0x80, 0x86, 0x07, 0X2B, 0XA1, 0XE7, 0XCC, 0x23,
    0x58, 0XBA, 0XEC, 0XA1, 0x34, 0XC8, 0x25, 0XA7
};

static uint8_t P384_k[] =
{
    0XB4, 0XB7, 0X4E, 0x44, 0XD7, 0X1A, 0x13, 0XD5,
    0x68, 0x00, 0X3D, 0x74, 0x89, 0x90, 0X8D, 0x56,
    0X4C, 0x77, 0x61, 0XE2, 0x29, 0XC5, 0X8C, 0XBF,
    0XA1, 0x89, 0x50, 0x09, 0X6E, 0XB7, 0x46, 0X3B,
    0x85, 0X4D, 0X7F, 0XA9, 0x92, 0XF9, 0x34, 0XD9,
    0x27, 0x37, 0x62, 0x85, 0XE6, 0x34, 0x14, 0XFA
};

static uint8_t P384_r[] =
{
    0XFB, 0x01, 0X7B, 0x91, 0X4E, 0x29, 0x14, 0x94,
    0x32, 0XD8, 0XBA, 0XC2, 0X9A, 0x51, 0x46, 0x40,
    0XB4, 0X6F, 0x53, 0XDD, 0XAB, 0X2C, 0x69, 0x94,
    0x80, 0x84, 0XE2, 0x93, 0X0F, 0X1C, 0X8F, 0X7E,
    0x08, 0XE0, 0X7C, 0X9C, 0x63, 0XF2, 0XD2, 0X1A,
    0x07, 0XDC, 0XB5, 0X6A, 0X6A, 0XF5, 0X6E, 0XB3
};

static uint8_t P384_s[] =
{
    0XB2, 0x63, 0XA1, 0x30, 0X5E, 0x05, 0X7F, 0x98,
    0X4D, 0x38, 0x72, 0X6A, 0X1B, 0x46, 0x87, 0x41,
    0x09, 0XF4, 0x17, 0XBC, 0XA1, 0x12, 0x67, 0X4C,
    0x52, 0x82, 0x62, 0XA4, 0X0A, 0x62, 0X9A, 0XF1,
    0XCB, 0XB9, 0XF5, 0x16, 0XCE, 0X0F, 0XA7, 0XD2,
    0XFF, 0x63, 0x08, 0x63, 0XA0, 0X0E, 0X8B, 0X9F
};



static uint8_t P521_p[] =
{
    0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF
};

static uint8_t P521_a[] =
{
    0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFC
};

static uint8_t P521_b[] =
{
    0x51, 0x95, 0x3E, 0xB9, 0x61, 0x8E, 0x1C, 0x9A,
    0x1F, 0x92, 0x9A, 0x21, 0xA0, 0xB6, 0x85, 0x40,
    0xEE, 0xA2, 0xDA, 0x72, 0x5B, 0x99, 0xB3, 0x15,
    0xF3, 0xB8, 0xB4, 0x89, 0x91, 0x8E, 0xF1, 0x09,
    0xE1, 0x56, 0x19, 0x39, 0x51, 0xEC, 0x7E, 0x93,
    0x7B, 0x16, 0x52, 0xC0, 0xBD, 0x3B, 0xB1, 0xBF,
    0x07, 0x35, 0x73, 0xDF, 0x88, 0x3D, 0x2C, 0x34,
    0xF1, 0xEF, 0x45, 0x1F, 0xD4, 0x6B, 0x50, 0x3F,
    0x00
};

static uint8_t P521_xg[] =
{
    0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9,
    0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4,
    0x42, 0x9c, 0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5,
    0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b, 0x4d, 0x3d,
    0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59,
    0x28, 0xfe, 0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8,
    0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42,
    0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd,
    0x66
};

static uint8_t P521_yg[] =
{
    0x01, 0x18, 0x39, 0x29, 0x6a, 0x78, 0x9a, 0x3b,
    0xc0, 0x04, 0x5c, 0x8a, 0x5f, 0xb4, 0x2c, 0x7d,
    0x1b, 0xd9, 0x98, 0xf5, 0x44, 0x49, 0x57, 0x9b,
    0x44, 0x68, 0x17, 0xaf, 0xbd, 0x17, 0x27, 0x3e,
    0x66, 0x2c, 0x97, 0xee, 0x72, 0x99, 0x5e, 0xf4,
    0x26, 0x40, 0xc5, 0x50, 0xb9, 0x01, 0x3f, 0xad,
    0x07, 0x61, 0x35, 0x3c, 0x70, 0x86, 0xa2, 0x72,
    0xc2, 0x40, 0x88, 0xbe, 0x94, 0x76, 0x9f, 0xd1,
    0x66, 0x50
};

// Base_pt_order:
static uint8_t P521_n[] =
{
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
    0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
    0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c,
    0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38,
    0x64, 0x09
};

static uint8_t P521_private_key[] =
{
    0x00, 0x65, 0XFD, 0XA3, 0x40, 0x94, 0x51, 0XDC,
    0XAB, 0X0A, 0X0E, 0XAD, 0x45, 0x49, 0x51, 0x12,
    0XA3, 0XD8, 0x13, 0XC1, 0X7B, 0XFD, 0x34, 0XBD,
    0XF8, 0XC1, 0x20, 0X9D, 0X7D, 0XF5, 0x84, 0x91,
    0x20, 0x59, 0x77, 0x79, 0x06, 0X0A, 0X7F, 0XF9,
    0XD7, 0x04, 0XAD, 0XF7, 0X8B, 0x57, 0X0F, 0XFA,
    0XD6, 0XF0, 0x62, 0XE9, 0X5C, 0X7E, 0X0C, 0X5D,
    0x54, 0x81, 0XC5, 0XB1, 0x53, 0XB4, 0X8B, 0x37,
    0X5F, 0XA1
};

static uint8_t P521_public_key_x[] =
{
    0x01, 0x51, 0x51, 0X8F, 0X1A, 0XF0, 0XF5, 0x63,
    0x51, 0X7E, 0XDD, 0x54, 0x85, 0x19, 0X0D, 0XF9,
    0X5A, 0X4B, 0XF5, 0X7B, 0X5C, 0XBA, 0X4C, 0XF2,
    0XA9, 0XA3, 0XF6, 0x47, 0x47, 0x25, 0XA3, 0X5F,
    0X7A, 0XFE, 0X0A, 0X6D, 0XDE, 0XB8, 0XBE, 0XDB,
    0XCD, 0X6A, 0x19, 0X7E, 0x59, 0X2D, 0x40, 0x18,
    0x89, 0x01, 0XCE, 0XCD, 0x65, 0x06, 0x99, 0XC9,
    0XB5, 0XE4, 0x56, 0XAE, 0XA5, 0XAD, 0XD1, 0x90,
    0x52, 0XA8
};

static uint8_t P521_public_key_y[] =
{
    0x00, 0X6F, 0X3B, 0x14, 0X2E, 0XA1, 0XBF, 0XFF,
    0X7E, 0x28, 0x37, 0XAD, 0x44, 0XC9, 0XE4, 0XFF,
    0X6D, 0X2D, 0x34, 0XC7, 0x31, 0x84, 0XBB, 0XAD,
    0x90, 0x02, 0X6D, 0XD5, 0XE6, 0XE8, 0x53, 0x17,
    0XD9, 0XDF, 0x45, 0XCA, 0XD7, 0x80, 0X3C, 0X6C,
    0x20, 0x03, 0X5B, 0X2F, 0X3F, 0XF6, 0X3A, 0XFF,
    0X4E, 0X1B, 0XA6, 0X4D, 0X1C, 0x07, 0x75, 0x77,
    0XDA, 0X3F, 0x42, 0x86, 0XC5, 0X8F, 0X0A, 0XEA,
    0XE6, 0x43
};

static uint8_t P521_hash[] =
{
    0x00, 0x00, 0XDD, 0XAF, 0x35, 0XA1, 0x93, 0x61,
    0X7A, 0XBA, 0XCC, 0x41, 0x73, 0x49, 0XAE, 0x20,
    0x41, 0x31, 0x12, 0XE6, 0XFA, 0X4E, 0x89, 0XA9,
    0X7E, 0XA2, 0X0A, 0X9E, 0XEE, 0XE6, 0X4B, 0x55,
    0XD3, 0X9A, 0x21, 0x92, 0x99, 0X2A, 0x27, 0X4F,
    0XC1, 0XA8, 0x36, 0XBA, 0X3C, 0x23, 0XA3, 0XFE,
    0XEB, 0XBD, 0x45, 0X4D, 0x44, 0x23, 0x64, 0X3C,
    0XE8, 0X0E, 0X2A, 0X9A, 0XC9, 0X4F, 0XA5, 0X4C,
    0XA4, 0X9F
};

static uint8_t P521_k[] =
{
    0x00, 0XC1, 0XC2, 0XB3, 0x05, 0x41, 0X9F, 0X5A,
    0x41, 0x34, 0X4D, 0X7E, 0x43, 0x59, 0x93, 0X3D,
    0x73, 0x40, 0x96, 0XF5, 0x56, 0x19, 0X7A, 0X9B,
    0x24, 0x43, 0x42, 0XB8, 0XB6, 0X2F, 0x46, 0XF9,
    0x37, 0x37, 0x78, 0XF9, 0XDE, 0X6B, 0x64, 0x97,
    0XB1, 0XEF, 0x82, 0X5F, 0XF2, 0X4F, 0x42, 0XF9,
    0XB4, 0XA4, 0XBD, 0x73, 0x82, 0XCF, 0XC3, 0x37,
    0X8A, 0x54, 0X0B, 0X1B, 0X7F, 0X0C, 0X1B, 0x95,
    0X6C, 0X2F
};

static uint8_t P521_r[] =
{
    0x01, 0x54, 0XFD, 0x38, 0x36, 0XAF, 0x92, 0XD0,
    0XDC, 0XA5, 0X7D, 0XD5, 0x34, 0X1D, 0x30, 0x53,
    0x98, 0x85, 0x34, 0XFD, 0XE8, 0x31, 0X8F, 0XC6,
    0XAA, 0XAA, 0XB6, 0X8E, 0X2E, 0X6F, 0x43, 0x39,
    0XB1, 0X9F, 0X2F, 0x28, 0X1A, 0X7E, 0X0B, 0x22,
    0XC2, 0x69, 0XD9, 0X3C, 0XF8, 0x79, 0X4A, 0x92,
    0x78, 0x88, 0X0E, 0XD7, 0XDB, 0XB8, 0XD9, 0x36,
    0X2C, 0XAE, 0XAC, 0XEE, 0x54, 0x43, 0x20, 0x55,
    0x22, 0x51
};

static uint8_t P521_s[] =
{
    0x01, 0x77, 0x05, 0XA7, 0x03, 0x02, 0x90, 0XD1,
    0XCE, 0XB6, 0x05, 0XA9, 0XA1, 0XBB, 0x03, 0XFF,
    0X9C, 0XDD, 0x52, 0X1E, 0x87, 0XA6, 0x96, 0XEC,
    0x92, 0X6C, 0X8C, 0x10, 0XC8, 0x36, 0X2D, 0XF4,
    0x97, 0x53, 0x67, 0x10, 0X1F, 0x67, 0XD1, 0XCF,
    0X9B, 0XCC, 0XBF, 0X2F, 0X3D, 0x23, 0x95, 0x34,
    0XFA, 0x50, 0X9E, 0x70, 0XAA, 0XC8, 0x51, 0XAE,
    0x01, 0XAA, 0XC6, 0X8D, 0x62, 0XF8, 0x66, 0x47,
    0x26, 0x60
};



// DSA Domain parameters:

// mod = L=1024, N=160 SHA-512:


// https://github.com/coruus/nist-testvectors/tree/master/csrc.nist.gov/groups/STM/cavp/documents/dss/186-3dsatestvectors

static uint8_t DSS_1024_160_p[] =
{
    0x88, 0xd9, 0x68, 0xe9, 0x60, 0x2e, 0xcb, 0xda,
    0x6d, 0x86, 0xf7, 0xc9, 0x70, 0xa3, 0xff, 0xbe,
    0xb1, 0xda, 0x96, 0x2f, 0x28, 0xc0, 0xaf, 0xb9,
    0x27, 0x0e, 0xf0, 0x5b, 0xc3, 0x30, 0xca, 0x98,
    0xc3, 0xad, 0xf8, 0x3c, 0x07, 0x2f, 0xeb, 0x05,
    0xfb, 0x2e, 0x29, 0x3b, 0x50, 0x65, 0xbb, 0xb0,
    0xcb, 0xcc, 0x93, 0x0c, 0x24, 0xd8, 0xd0, 0x78,
    0x69, 0xde, 0xae, 0xcd, 0x92, 0xa2, 0x60, 0x4c,
    0x0f, 0x5d, 0xd3, 0x5c, 0x5b, 0x43, 0x1f, 0xda,
    0x6a, 0x22, 0x2c, 0x52, 0xc3, 0x56, 0x2b, 0xf7,
    0x57, 0x1c, 0x71, 0x02, 0x09, 0xbe, 0x8b, 0x3b,
    0x85, 0x88, 0x18, 0x78, 0x87, 0x25, 0xfe, 0x81,
    0x12, 0xb7, 0xd6, 0xbc, 0x82, 0xe0, 0xff, 0x1c,
    0xbb, 0xf5, 0xd6, 0xfe, 0x94, 0x69, 0x0a, 0xf2,
    0xb5, 0x10, 0xe4, 0x1a, 0xd8, 0x20, 0x7d, 0xc2,
    0xc0, 0x2f, 0xb9, 0xfa, 0x5c, 0xef, 0xaa, 0xb5
};

static uint8_t DSS_1024_160_q[] =
{
    0xa6, 0x65, 0x68, 0x9b, 0x9e, 0x5b, 0x9c, 0xe8,
    0x2f, 0xd1, 0x67, 0x60, 0x06, 0xcf, 0x4c, 0xf6,
    0x7e, 0xcc, 0x56, 0xb7
};

static uint8_t DSS_1024_160_g[] =
{
    0x26, 0x7e, 0x28, 0x28, 0x57, 0x41, 0x77, 0x52,
    0x11, 0x3f, 0xba, 0x3f, 0xca, 0x71, 0x55, 0xb5,
    0xce, 0x89, 0xe7, 0xc8, 0xa3, 0x3c, 0x1a, 0x29,
    0x12, 0x2e, 0x2b, 0x72, 0x09, 0x65, 0xfc, 0x04,
    0x24, 0x52, 0x67, 0xff, 0x87, 0xfc, 0x67, 0xa5,
    0x73, 0x0f, 0xe5, 0xb3, 0x08, 0x01, 0x3a, 0xa3,
    0x26, 0x69, 0x90, 0xfb, 0xb3, 0x98, 0x18, 0x5a,
    0x87, 0xe0, 0x55, 0xb4, 0x43, 0xa8, 0x68, 0xce,
    0x0c, 0xe1, 0x3a, 0xe6, 0xae, 0xe3, 0x30, 0xb9,
    0xd2, 0x5d, 0x3b, 0xbb, 0x36, 0x26, 0x65, 0xc5,
    0x88, 0x1d, 0xaf, 0x0c, 0x5a, 0xa7, 0x5e, 0x9d,
    0x4a, 0x82, 0xe8, 0xf0, 0x4c, 0x91, 0xa9, 0xad,
    0x29, 0x48, 0x22, 0xe3, 0x39, 0x78, 0xab, 0x0c,
    0x13, 0xfa, 0xdc, 0x45, 0x83, 0x1f, 0x9d, 0x37,
    0xda, 0x4e, 0xfa, 0x0f, 0xc2, 0xc5, 0xeb, 0x01,
    0x37, 0x1f, 0xa8, 0x5b, 0x7d, 0xdb, 0x1f, 0x82
};

static uint8_t DSS_1024_160_private_key[] =   // aka x
{
    0x07, 0xce, 0x88, 0x62, 0xe6, 0x4b, 0x7f, 0x6c,
    0x74, 0x82, 0x04, 0x6d, 0xbf, 0xc9, 0x39, 0x07,
    0x12, 0x3e, 0x52, 0x14
};

static uint8_t DSS_1024_160_public_key[] =   // aka y
{
    0x60, 0xf5, 0x34, 0x1e, 0x48, 0xca, 0x7a, 0x3b,
    0xc5, 0xde, 0xce, 0xe6, 0x12, 0x11, 0xdd, 0x27,
    0x27, 0xcd, 0x8e, 0x2f, 0xc7, 0x63, 0x5f, 0x3a,
    0xab, 0xea, 0x26, 0x23, 0x66, 0xe4, 0x58, 0xf5,
    0xc5, 0x1c, 0x31, 0x1a, 0xfd, 0xa9, 0x16, 0xcb,
    0x0d, 0xcd, 0xc5, 0xd5, 0xa5, 0x72, 0x9f, 0x57,
    0x3a, 0x53, 0x2b, 0x59, 0x47, 0x43, 0x19, 0x9b,
    0xcf, 0xa7, 0x45, 0x49, 0x03, 0xe7, 0x4b, 0x33,
    0xdd, 0xfe, 0x65, 0x89, 0x63, 0x06, 0xce, 0xc2,
    0x0e, 0xbd, 0x84, 0x27, 0x68, 0x2f, 0xa5, 0x01,
    0xee, 0x06, 0xbc, 0x4c, 0x5d, 0x14, 0x25, 0xcb,
    0xe3, 0x18, 0x28, 0xba, 0x00, 0x8b, 0x19, 0xc9,
    0xda, 0x68, 0x13, 0x6c, 0xf7, 0x18, 0x40, 0xb2,
    0x05, 0x91, 0x9e, 0x78, 0x3a, 0x62, 0x8a, 0x5a,
    0x57, 0xcf, 0x91, 0xcf, 0x56, 0x9b, 0x28, 0x54,
    0xff, 0xef, 0x7a, 0x09, 0x6e, 0xda, 0x96, 0xc9
};

uint8_t DSS_1024_160_hash[] =
{
    0x3E, 0x23, 0xE8, 0xB2, 0x4D, 0x50, 0x54, 0x5D,
    0xC2, 0x93, 0x5B, 0x5A, 0x1F, 0x40, 0x2E, 0x9C,
    0x4C, 0xC7, 0xB8, 0xFC
};

static uint8_t DSS_1024_160_k[] =
{
    0x2f, 0x17, 0x09, 0x07, 0xac, 0x69, 0x72, 0x6b,
    0x14, 0xf2, 0x20, 0x56, 0xdc, 0xb3, 0x7b, 0x4d,
    0xf8, 0x5f, 0x74, 0x24
};

static uint8_t DSS_1024_160_r[] =
{
    0xa5, 0x3f, 0x1f, 0x8f, 0x20, 0xb8, 0xd3, 0xd4,
    0x72, 0x0f, 0x14, 0xa8, 0xba, 0xb5, 0x22, 0x6b,
    0x07, 0x9d, 0x99, 0x53
};

static uint8_t DSS_1024_160_s[] =
{
    0x11, 0xf5, 0x3f, 0x6a, 0x4e, 0x56, 0xb5, 0x1f,
    0x60, 0xe2, 0x0d, 0x49, 0x57, 0xae, 0x89, 0xe1,
    0x62, 0xae, 0xa6, 0x16
};



// mod = L=2048, N=224 SHA-512:

static uint8_t DSS_2048_224_p[] =
{
    0xbf, 0xeb, 0xd0, 0x00, 0xb2, 0xd6, 0xcd, 0x4a,
    0xb3, 0x8e, 0xfb, 0xa3, 0x5d, 0xf3, 0x34, 0xdf,
    0x72, 0x1d, 0x6c, 0x2f, 0x2b, 0x3d, 0x95, 0x66,
    0x79, 0xcb, 0xad, 0x00, 0x9f, 0x3d, 0xfb, 0xd0,
    0x02, 0x95, 0x2c, 0xc8, 0x99, 0xcc, 0x23, 0x56,
    0xec, 0x87, 0x69, 0xbd, 0x3d, 0x1b, 0xa5, 0xa7,
    0x30, 0x23, 0x72, 0x98, 0x88, 0xda, 0x92, 0xca,
    0x48, 0xa5, 0xee, 0x94, 0xc9, 0x7f, 0x4f, 0x04,
    0xa2, 0xe3, 0xac, 0xb4, 0xf3, 0x3a, 0x2f, 0x0f,
    0xb3, 0x78, 0x3c, 0x31, 0xf2, 0xc7, 0x0f, 0xa7,
    0xc7, 0x0f, 0x38, 0x21, 0x4a, 0x27, 0xda, 0xde,
    0xc8, 0xb1, 0x2e, 0x67, 0x99, 0x6a, 0x9e, 0x85,
    0xee, 0x3b, 0xb1, 0x48, 0x80, 0x31, 0x30, 0x14,
    0x73, 0x92, 0xdc, 0x52, 0x53, 0xc0, 0x4d, 0x70,
    0x63, 0x53, 0x5e, 0x6c, 0xd6, 0x46, 0xbf, 0xb1,
    0x86, 0x98, 0x4e, 0x08, 0xb5, 0x8b, 0x74, 0xa7,
    0xbe, 0x5b, 0x33, 0x3b, 0xf3, 0x2b, 0x0a, 0xbf,
    0xd5, 0x66, 0x53, 0x60, 0xe9, 0xa9, 0x23, 0xa0,
    0xc5, 0x28, 0xff, 0x1c, 0x62, 0xc7, 0x25, 0x34,
    0x58, 0xf5, 0x67, 0x85, 0x28, 0x71, 0x9d, 0x43,
    0x6e, 0x50, 0x14, 0x87, 0x41, 0xf4, 0x5d, 0xc7,
    0xdd, 0x2c, 0x6c, 0xac, 0x71, 0xc5, 0x52, 0x31,
    0xf1, 0x2a, 0x83, 0xfe, 0xfd, 0x2e, 0xd0, 0xa3,
    0x3e, 0xde, 0x1b, 0x8a, 0x51, 0xf5, 0x66, 0xfc,
    0xf7, 0x89, 0x06, 0x82, 0xcd, 0xc1, 0x93, 0x1d,
    0xc2, 0x07, 0xc9, 0x2b, 0xf2, 0xef, 0x4e, 0x28,
    0xab, 0x31, 0x66, 0x1e, 0xeb, 0x77, 0xf1, 0x60,
    0x1e, 0xea, 0x94, 0x1c, 0x95, 0x91, 0xf0, 0x38,
    0xd3, 0xf0, 0x0d, 0x91, 0x28, 0x57, 0xdb, 0x05,
    0xe6, 0x4b, 0x2a, 0xd5, 0x69, 0x32, 0x00, 0x61,
    0xc6, 0xf8, 0x63, 0xff, 0x33, 0x54, 0xd8, 0x42,
    0xe7, 0xe7, 0xea, 0x71, 0x5a, 0xfe, 0xf8, 0xd1
};

static uint8_t DSS_2048_224_q[] =
{
    0xaa, 0x98, 0x6d, 0xf8, 0xa0, 0x64, 0x27, 0x8e,
    0x93, 0x63, 0x31, 0x6a, 0x98, 0x30, 0xbc, 0xfa,
    0x49, 0x06, 0x56, 0xfa, 0xa6, 0xd5, 0xda, 0xa8,
    0x17, 0xd8, 0x79, 0x49
};

static uint8_t DSS_2048_224_g[] =
{
    0x81, 0x95, 0xad, 0x9a, 0x47, 0x8f, 0xd9, 0x85,
    0x21, 0x6e, 0xe5, 0x83, 0x68, 0x36, 0x6d, 0x2e,
    0xdd, 0x13, 0xc1, 0x2b, 0x3d, 0x62, 0x23, 0x91,
    0x69, 0xfa, 0x04, 0x2d, 0x91, 0x15, 0x64, 0x08,
    0xb4, 0x83, 0x12, 0x2f, 0x44, 0xed, 0x62, 0x36,
    0xb8, 0x30, 0x8a, 0x6c, 0xdb, 0x52, 0xf9, 0xaf,
    0x3d, 0xe8, 0x8e, 0xc8, 0x9e, 0x03, 0x9a, 0xfa,
    0xd7, 0xda, 0x3a, 0xa6, 0x6c, 0x19, 0x76, 0x04,
    0x9a, 0x8e, 0x0a, 0x7d, 0x18, 0xd5, 0x67, 0xba,
    0xf9, 0x9f, 0xce, 0xfe, 0x31, 0x5c, 0xad, 0xa0,
    0x15, 0x48, 0x38, 0x6b, 0x10, 0xb2, 0x5e, 0x52,
    0xf5, 0x2e, 0xd7, 0x8e, 0xb4, 0xd2, 0x80, 0x82,
    0xe5, 0xe1, 0xff, 0xee, 0x94, 0x80, 0xc4, 0xfe,
    0x2c, 0xc4, 0xaa, 0xfd, 0x1e, 0xfc, 0x9d, 0x4f,
    0xd2, 0xcc, 0x6d, 0x15, 0x59, 0x68, 0x93, 0x12,
    0x71, 0xef, 0x15, 0xb3, 0x24, 0x0e, 0x7f, 0xb0,
    0x43, 0xa8, 0x0c, 0x8f, 0x62, 0x8b, 0xef, 0xe0,
    0x9d, 0x64, 0x50, 0x77, 0xc1, 0x02, 0x9d, 0x21,
    0xe0, 0xac, 0x8b, 0xf0, 0xba, 0x9c, 0x27, 0x71,
    0x4d, 0x1b, 0x58, 0x0e, 0xde, 0x59, 0x4a, 0xa0,
    0x1b, 0x3b, 0x76, 0xf6, 0xe7, 0x45, 0xfc, 0x1e,
    0xc0, 0x7d, 0xb3, 0x7e, 0x2f, 0xd7, 0xe9, 0x8c,
    0x6c, 0x8c, 0x69, 0x15, 0x22, 0x8e, 0x42, 0x2c,
    0x30, 0x9d, 0xe9, 0xf5, 0xdb, 0x16, 0x8f, 0x50,
    0x24, 0x9d, 0x1b, 0xe1, 0xed, 0x32, 0x98, 0x09,
    0x08, 0x08, 0xe2, 0xeb, 0xb8, 0x96, 0xbb, 0x79,
    0xb8, 0xc4, 0xcb, 0xf9, 0x4d, 0x4c, 0x20, 0x64,
    0xe3, 0x7e, 0x61, 0x2b, 0xa4, 0x44, 0x9d, 0x7a,
    0xc2, 0x10, 0xed, 0xde, 0x21, 0x14, 0x16, 0xd6,
    0x4b, 0x05, 0x1d, 0xd8, 0x04, 0x6a, 0xb0, 0x41,
    0x73, 0x26, 0x65, 0x41, 0x1a, 0x7f, 0x15, 0x4d,
    0x31, 0xb3, 0xe1, 0x1a, 0x51, 0xda, 0x7f, 0xc0
};


uint8_t DSS_2048_224_private_key[] =   // aka x
{
    0x6a, 0x5b, 0x4f, 0xfc, 0x44, 0x23, 0x8d, 0x18,
    0x52, 0xfb, 0x9b, 0x74, 0xe4, 0xc1, 0x66, 0x1b,
    0xe8, 0x59, 0x84, 0x04, 0x3c, 0xfe, 0xee, 0x02,
    0x3f, 0x57, 0xca, 0xc6
};

uint8_t DSS_2048_224_public_key[] =   // aka y
{
    0xaf, 0x67, 0x21, 0xbf, 0x75, 0xde, 0xc6, 0xa1,
    0xb7, 0x6a, 0xd3, 0x5c, 0xa3, 0x75, 0x0d, 0xef,
    0x31, 0x11, 0x7c, 0x5b, 0x44, 0x1c, 0x15, 0xa3,
    0x06, 0x83, 0x5a, 0x1d, 0xb7, 0x4c, 0x00, 0x3b,
    0x86, 0xae, 0x90, 0x99, 0xeb, 0xfb, 0x74, 0x5b,
    0x0a, 0xa9, 0xcb, 0x00, 0x0c, 0xf4, 0x3f, 0xb0,
    0x21, 0x51, 0x3b, 0x8f, 0x19, 0x7b, 0xc8, 0x65,
    0xb2, 0x2b, 0xf9, 0x49, 0xb4, 0x91, 0x80, 0x9a,
    0xd7, 0x52, 0xff, 0xc1, 0xca, 0x8e, 0x54, 0xbe,
    0xa1, 0x6d, 0xc7, 0xf5, 0x39, 0xe4, 0xc5, 0x5f,
    0xb7, 0x0a, 0x77, 0x43, 0xdd, 0x28, 0xf2, 0x62,
    0xf6, 0x0e, 0xf0, 0xf2, 0xfc, 0xaa, 0xc2, 0x9e,
    0x80, 0x21, 0xa7, 0x93, 0x8c, 0x18, 0xff, 0xe0,
    0x30, 0x75, 0xd0, 0xb7, 0xe0, 0xa2, 0xb4, 0xdc,
    0xab, 0xe4, 0x6e, 0xd1, 0x95, 0x3d, 0x33, 0xe3,
    0x7f, 0x11, 0x3a, 0xf5, 0x19, 0xab, 0x0b, 0xf0,
    0xb6, 0x18, 0x6c, 0x12, 0xb5, 0xf6, 0x48, 0x84,
    0x37, 0xf5, 0x19, 0x30, 0x96, 0xe2, 0xfd, 0x6a,
    0x6a, 0x18, 0x35, 0x60, 0x47, 0x94, 0xc6, 0x6b,
    0x42, 0xae, 0x52, 0x65, 0xc1, 0xcf, 0x1c, 0xb5,
    0x3a, 0xe8, 0x49, 0x97, 0x97, 0x5e, 0x03, 0x18,
    0xa9, 0x3c, 0xe4, 0x1e, 0x39, 0x02, 0xe4, 0xef,
    0x54, 0xde, 0x3c, 0x56, 0x55, 0x5b, 0xd1, 0x94,
    0x91, 0xac, 0xd5, 0x3f, 0x3e, 0x57, 0x46, 0x4e,
    0x1f, 0x46, 0x03, 0x89, 0xdb, 0xc5, 0xfa, 0x80,
    0x64, 0x8f, 0xa5, 0xa5, 0xa0, 0xf2, 0x95, 0x6e,
    0x9e, 0xc3, 0xb8, 0xdc, 0x44, 0x1b, 0x53, 0x5c,
    0x64, 0x1c, 0x36, 0x2e, 0xed, 0x77, 0x0d, 0xa8,
    0x28, 0x64, 0x9b, 0xfd, 0x14, 0x64, 0x72, 0xb0,
    0xf4, 0x6a, 0x4c, 0x06, 0x4e, 0x45, 0x9f, 0x88,
    0xbf, 0xf9, 0x0d, 0xed, 0xe7, 0xec, 0x56, 0x17,
    0x7a, 0x9a, 0x71, 0xd1, 0x67, 0x94, 0x87, 0x12
};

uint8_t DSS_2048_224_msg[] =
{
    0xe9, 0xf5, 0x9c, 0x6a, 0x5c, 0xbe, 0x8f, 0x5b,
    0x0c, 0xf7, 0x50, 0x08, 0xd0, 0x6a, 0x07, 0x6a,
    0x67, 0x39, 0xbd, 0xdd, 0xb3, 0x9b, 0x82, 0x14,
    0x3c, 0xd0, 0x39, 0x39, 0xaa, 0x47, 0x38, 0xa2,
    0x87, 0xc2, 0xa6, 0xf3, 0x18, 0x29, 0xbb, 0xe1,
    0x5f, 0x02, 0xcc, 0x2e, 0xe7, 0xd7, 0x12, 0x2d,
    0xbd, 0x13, 0x28, 0x25, 0x97, 0x0d, 0xad, 0xdd,
    0x8a, 0x4d, 0x85, 0x1d, 0xa8, 0x6e, 0x7e, 0xdc,
    0x89, 0x40, 0xcb, 0x11, 0x88, 0x31, 0x92, 0x18,
    0xb8, 0xe0, 0x24, 0x8a, 0x10, 0x3e, 0xae, 0x34,
    0xbc, 0x68, 0xd8, 0x5f, 0x5a, 0x32, 0x83, 0x0d,
    0x7e, 0x5d, 0xc7, 0x71, 0x8f, 0x74, 0xdb, 0x5e,
    0x42, 0x24, 0xc0, 0xde, 0xbe, 0x1e, 0x84, 0x1e,
    0x1e, 0xea, 0x1a, 0x88, 0xfe, 0xe0, 0xf8, 0x5d,
    0x9f, 0xb0, 0x87, 0xcb, 0xce, 0xe5, 0x5f, 0x86,
    0x03, 0x7a, 0x64, 0x6e, 0x38, 0x34, 0x6d, 0x2b
};

uint8_t DSS_2048_224_hash[] =
{
    0XAC, 0x18, 0x64, 0X9C, 0x06, 0XAA, 0XAA, 0XA9,
    0x67, 0X2A, 0X6F, 0XDA, 0x76, 0XF6, 0XFC, 0XE8,
    0XE1, 0x86, 0x51, 0x55, 0x85, 0x71, 0XBC, 0XFD,
    0X8A, 0x19, 0XAC, 0x35
};

uint8_t DSS_2048_224_k[] =
{
    0x9c, 0xed, 0x89, 0xea, 0x50, 0x50, 0x98, 0x22,
    0x22, 0x83, 0x0e, 0xfe, 0xf2, 0x6e, 0x73, 0x94,
    0xf5, 0xab, 0x7d, 0x83, 0x7d, 0x45, 0x49, 0x96,
    0x2d, 0x28, 0x5f, 0xae
};

uint8_t DSS_2048_224_r[] =
{
    0x9d, 0xa9, 0x96, 0x65, 0x00, 0xde, 0x9d, 0x3b,
    0x6b, 0x7f, 0x44, 0x1c, 0xa5, 0x50, 0x23, 0x3f,
    0xc4, 0x50, 0x94, 0x4b, 0xc5, 0x07, 0xe0, 0x1c,
    0xd4, 0xac, 0xb0, 0x30
};

uint8_t DSS_2048_224_s[] =
{
    0x2d, 0x72, 0xf1, 0xf6, 0x68, 0x1e, 0x86, 0x7f,
    0x7d, 0x8b, 0xea, 0xeb, 0xeb, 0xa4, 0xbc, 0x5b,
    0x23, 0x28, 0x76, 0x04, 0xa6, 0x4c, 0xfe, 0xe1,
    0xc1, 0x64, 0x59, 0x5a
};



// mod = L=3072, N=256 SHA-512:

uint8_t DSS_3072_256_p[] =
{
    0xc1, 0xd0, 0xa6, 0xd0, 0xb5, 0xed, 0x61, 0x5d,
    0xee, 0x76, 0xac, 0x5a, 0x60, 0xdd, 0x35, 0xec,
    0xb0, 0x00, 0xa2, 0x02, 0x06, 0x30, 0x18, 0xb1,
    0xba, 0x0a, 0x06, 0xfe, 0x7a, 0x00, 0xf7, 0x65,
    0xdb, 0x1c, 0x59, 0xa6, 0x80, 0xce, 0xcf, 0xe3,
    0xad, 0x41, 0x47, 0x5b, 0xad, 0xb5, 0xad, 0x50,
    0xb6, 0x14, 0x7e, 0x25, 0x96, 0xb8, 0x8d, 0x34,
    0x65, 0x60, 0x52, 0xac, 0xa7, 0x94, 0x86, 0xea,
    0x6f, 0x6e, 0xc9, 0x0b, 0x23, 0xe3, 0x63, 0xf3,
    0xab, 0x8c, 0xdc, 0x8b, 0x93, 0xb6, 0x2a, 0x07,
    0x0e, 0x02, 0x68, 0x8e, 0xa8, 0x77, 0x84, 0x3a,
    0x46, 0x85, 0xc2, 0xba, 0x6d, 0xb1, 0x11, 0xe9,
    0xad, 0xdb, 0xd7, 0xca, 0x4b, 0xce, 0x65, 0xbb,
    0x10, 0xc9, 0xce, 0xb6, 0x9b, 0xf8, 0x06, 0xe2,
    0xeb, 0xd7, 0xe5, 0x4e, 0xde, 0xb7, 0xf9, 0x96,
    0xa6, 0x5c, 0x90, 0x7b, 0x50, 0xef, 0xdf, 0x8e,
    0x57, 0x5b, 0xae, 0x46, 0x2a, 0x21, 0x9c, 0x30,
    0x2f, 0xef, 0x2a, 0xe8, 0x1d, 0x73, 0xce, 0xe7,
    0x52, 0x74, 0x62, 0x5b, 0x5f, 0xc2, 0x9c, 0x6d,
    0x60, 0xc0, 0x57, 0xed, 0x9e, 0x7b, 0x0d, 0x46,
    0xad, 0x2f, 0x57, 0xfe, 0x01, 0xf8, 0x23, 0x23,
    0x0f, 0x31, 0x42, 0x27, 0x22, 0x31, 0x9c, 0xe0,
    0xab, 0xf1, 0xf1, 0x41, 0xf3, 0x26, 0xc0, 0x0f,
    0xbc, 0x2b, 0xe4, 0xcd, 0xb8, 0x94, 0x4b, 0x6f,
    0xd0, 0x50, 0xbd, 0x30, 0x0b, 0xdb, 0x1c, 0x5f,
    0x4d, 0xa7, 0x25, 0x37, 0xe5, 0x53, 0xe0, 0x1d,
    0x51, 0x23, 0x9c, 0x4d, 0x46, 0x18, 0x60, 0xf1,
    0xfb, 0x4f, 0xd8, 0xfa, 0x79, 0xf5, 0xd5, 0x26,
    0x3f, 0xf6, 0x2f, 0xed, 0x70, 0x08, 0xe2, 0xe0,
    0xa2, 0xd3, 0x6b, 0xf7, 0xb9, 0x06, 0x2d, 0x0d,
    0x75, 0xdb, 0x22, 0x6c, 0x34, 0x64, 0xb6, 0x7b,
    0xa2, 0x41, 0x01, 0xb0, 0x85, 0xf2, 0xc6, 0x70,
    0xc0, 0xf8, 0x7a, 0xe5, 0x30, 0xd9, 0x8e, 0xe6,
    0x0c, 0x54, 0x72, 0xf4, 0xaa, 0x15, 0xfb, 0x25,
    0x04, 0x1e, 0x19, 0x10, 0x63, 0x54, 0xda, 0x06,
    0xbc, 0x2b, 0x1d, 0x32, 0x2d, 0x40, 0xed, 0x97,
    0xb2, 0x1f, 0xd1, 0xcd, 0xad, 0x30, 0x25, 0xc6,
    0x9d, 0xa6, 0xce, 0x9c, 0x7d, 0xdf, 0x3d, 0xcf,
    0x1e, 0xa4, 0xd5, 0x65, 0x77, 0xbf, 0xde, 0xc2,
    0x30, 0x71, 0xc1, 0xf0, 0x5e, 0xe4, 0x07, 0x7b,
    0x53, 0x91, 0xe9, 0xa4, 0x04, 0xea, 0xff, 0xe1,
    0x2d, 0x1e, 0xa6, 0x2d, 0x06, 0xac, 0xd6, 0xbf,
    0x19, 0xe9, 0x1a, 0x15, 0x8d, 0x20, 0x66, 0xb4,
    0xcd, 0x20, 0xe4, 0xc4, 0xe5, 0x2f, 0xfb, 0x1d,
    0x52, 0x04, 0xcd, 0x02, 0x2b, 0xc7, 0x10, 0x8f,
    0x2c, 0x79, 0x9f, 0xb4, 0x68, 0x86, 0x6e, 0xf1,
    0xcb, 0x09, 0xbc, 0xe0, 0x9d, 0xfd, 0x49, 0xe4,
    0x74, 0x0f, 0xf8, 0x14, 0x04, 0x97, 0xbe, 0x61
};

uint8_t DSS_3072_256_q[] =
{
    0xbf, 0x65, 0x44, 0x1c, 0x98, 0x7b, 0x77, 0x37,
    0x38, 0x5e, 0xad, 0xec, 0x15, 0x8d, 0xd0, 0x16,
    0x14, 0xda, 0x6f, 0x15, 0x38, 0x62, 0x48, 0xe5,
    0x9f, 0x3c, 0xdd, 0xbe, 0xfc, 0x8e, 0x9d, 0xd1
};

uint8_t DSS_3072_256_g[] =
{
    0xc0, 0x2a, 0xc8, 0x53, 0x75, 0xfa, 0xb8, 0x0b,
    0xa2, 0xa7, 0x84, 0xb9, 0x4e, 0x4d, 0x14, 0x5b,
    0x3b, 0xe0, 0xf9, 0x20, 0x90, 0xeb, 0xa1, 0x7b,
    0xd1, 0x23, 0x58, 0xcf, 0x3e, 0x03, 0xf4, 0x37,
    0x95, 0x84, 0xf8, 0x74, 0x22, 0x52, 0xf7, 0x6b,
    0x1e, 0xde, 0x3f, 0xc3, 0x72, 0x81, 0x42, 0x0e,
    0x74, 0xa9, 0x63, 0xe4, 0xc0, 0x88, 0x79, 0x6f,
    0xf2, 0xba, 0xb8, 0xdb, 0x6e, 0x9a, 0x45, 0x30,
    0xfc, 0x67, 0xd5, 0x1f, 0x88, 0xb9, 0x05, 0xab,
    0x43, 0x99, 0x5a, 0xab, 0x46, 0x36, 0x4c, 0xb4,
    0x0c, 0x12, 0x56, 0xf0, 0x46, 0x6f, 0x3d, 0xbc,
    0xe3, 0x62, 0x03, 0xef, 0x22, 0x8b, 0x35, 0xe9,
    0x02, 0x47, 0xe9, 0x5e, 0x51, 0x15, 0xe8, 0x31,
    0xb1, 0x26, 0xb6, 0x28, 0xee, 0x98, 0x4f, 0x34,
    0x99, 0x11, 0xd3, 0x0f, 0xfb, 0x9d, 0x61, 0x3b,
    0x50, 0xa8, 0x4d, 0xfa, 0x1f, 0x04, 0x2b, 0xa5,
    0x36, 0xb8, 0x2d, 0x51, 0x01, 0xe7, 0x11, 0xc6,
    0x29, 0xf9, 0xf2, 0x09, 0x6d, 0xc8, 0x34, 0xde,
    0xec, 0x63, 0xb7, 0x0f, 0x2a, 0x23, 0x15, 0xa6,
    0xd2, 0x73, 0x23, 0xb9, 0x95, 0xaa, 0x20, 0xd3,
    0xd0, 0x73, 0x70, 0x75, 0x18, 0x6f, 0x50, 0x49,
    0xaf, 0x6f, 0x51, 0x2a, 0x0c, 0x38, 0xa9, 0xda,
    0x06, 0x81, 0x7f, 0x4b, 0x61, 0x9b, 0x94, 0x52,
    0x0e, 0xdf, 0xac, 0x85, 0xc4, 0xa6, 0xe2, 0xe1,
    0x86, 0x22, 0x5c, 0x95, 0xa0, 0x4e, 0xc3, 0xc3,
    0x42, 0x2b, 0x8d, 0xeb, 0x28, 0x4e, 0x98, 0xd2,
    0x4b, 0x31, 0x46, 0x58, 0x02, 0x00, 0x8a, 0x09,
    0x7c, 0x25, 0x96, 0x9e, 0x82, 0x6c, 0x2b, 0xaa,
    0x59, 0xd2, 0xcb, 0xa3, 0x3d, 0x6c, 0x1d, 0x9f,
    0x39, 0x62, 0x33, 0x0c, 0x1f, 0xcd, 0xa7, 0xcf,
    0xb1, 0x85, 0x08, 0xfe, 0xa7, 0xd0, 0x55, 0x5e,
    0x3a, 0x16, 0x9d, 0xae, 0xd3, 0x53, 0xf3, 0xee,
    0x6f, 0x4b, 0xb3, 0x02, 0x44, 0x31, 0x91, 0x61,
    0xdf, 0xf6, 0x43, 0x8a, 0x37, 0xca, 0x79, 0x3b,
    0x24, 0xbb, 0xb1, 0xb1, 0xbc, 0x21, 0x94, 0xfc,
    0x6e, 0x6e, 0xf6, 0x02, 0x78, 0x15, 0x78, 0x99,
    0xcb, 0x03, 0xc5, 0xdd, 0x6f, 0xc9, 0x1a, 0x83,
    0x6e, 0xb2, 0x0a, 0x25, 0xc0, 0x99, 0x45, 0x64,
    0x3d, 0x95, 0xf7, 0xbd, 0x50, 0xd2, 0x06, 0x68,
    0x4d, 0x6f, 0xfc, 0x14, 0xd1, 0x6d, 0x82, 0xd5,
    0xf7, 0x81, 0x22, 0x5b, 0xff, 0x90, 0x83, 0x92,
    0xa5, 0x79, 0x3b, 0x80, 0x3f, 0x9b, 0x70, 0xb4,
    0xdf, 0xcb, 0x39, 0x4f, 0x9e, 0xd8, 0x1c, 0x18,
    0xe3, 0x91, 0xa0, 0x9e, 0xb3, 0xf9, 0x3a, 0x03,
    0x2d, 0x81, 0xba, 0x67, 0x0c, 0xab, 0xfd, 0x6f,
    0x64, 0xaa, 0x5e, 0x33, 0x74, 0xcb, 0x7c, 0x20,
    0x29, 0xf4, 0x52, 0x00, 0xe4, 0xf0, 0xbf, 0xd8,
    0x20, 0xc8, 0xbd, 0x58, 0xdc, 0x5e, 0xeb, 0x34
};

uint8_t DSS_3072_256_private_key[] =   // aka x
{
    0x15, 0x0b, 0x5c, 0x51, 0xea, 0x64, 0x02, 0x27,
    0x6b, 0xc9, 0x12, 0x32, 0x2f, 0x04, 0x04, 0xf6,
    0xd5, 0x7f, 0xf7, 0xd3, 0x2a, 0xfc, 0xaa, 0x83,
    0xb6, 0xdf, 0xde, 0x11, 0xab, 0xb4, 0x81, 0x81
};

uint8_t DSS_3072_256_public_key[] =   // aka y
{
    0x6d, 0xa5, 0x4f, 0x2b, 0x0d, 0xdb, 0x4d, 0xcc,
    0xe2, 0xda, 0x1e, 0xdf, 0xa1, 0x6b, 0xa8, 0x49,
    0x53, 0xd8, 0x42, 0x9c, 0xe6, 0x0c, 0xd1, 0x11,
    0xa5, 0xc6, 0x5e, 0xdc, 0xf7, 0xba, 0x5b, 0x8d,
    0x93, 0x87, 0xab, 0x68, 0x81, 0xc2, 0x48, 0x80,
    0xb2, 0xaf, 0xbd, 0xb4, 0x37, 0xe9, 0xed, 0x7f,
    0xfb, 0x8e, 0x96, 0xbe, 0xca, 0x7e, 0xa8, 0x0d,
    0x1d, 0x90, 0xf2, 0x4d, 0x54, 0x61, 0x12, 0x62,
    0x9d, 0xf5, 0xc9, 0xe9, 0x66, 0x17, 0x42, 0xcc,
    0x87, 0x2f, 0xdb, 0x3d, 0x40, 0x9b, 0xc7, 0x7b,
    0x75, 0xb1, 0x7c, 0x7e, 0x6c, 0xff, 0xf8, 0x62,
    0x61, 0x07, 0x1c, 0x4b, 0x5c, 0x9f, 0x98, 0x98,
    0xbe, 0x1e, 0x9e, 0x27, 0x34, 0x9b, 0x93, 0x3c,
    0x34, 0xfb, 0x34, 0x56, 0x85, 0xf8, 0xfc, 0x6c,
    0x12, 0x47, 0x0d, 0x12, 0x4c, 0xec, 0xf5, 0x1b,
    0x5d, 0x5a, 0xdb, 0xf5, 0xe7, 0xa2, 0x49, 0x0f,
    0x8d, 0x67, 0xaa, 0xc5, 0x3a, 0x82, 0xed, 0x6a,
    0x21, 0x10, 0x68, 0x6c, 0xf6, 0x31, 0xc3, 0x48,
    0xbc, 0xbc, 0x4c, 0xf1, 0x56, 0xf3, 0xa6, 0x98,
    0x01, 0x63, 0xe2, 0xfe, 0xca, 0x72, 0xa4, 0x5f,
    0x6b, 0x3d, 0x68, 0xc1, 0x0e, 0x5a, 0x22, 0x83,
    0xb4, 0x70, 0xb7, 0x29, 0x26, 0x74, 0x49, 0x03,
    0x83, 0xf7, 0x5f, 0xa2, 0x6c, 0xcf, 0x93, 0xc0,
    0xe1, 0xc8, 0xd0, 0x62, 0x8c, 0xa3, 0x5f, 0x2f,
    0x3d, 0x9b, 0x68, 0x76, 0x50, 0x5d, 0x11, 0x89,
    0x88, 0x95, 0x72, 0x37, 0xa2, 0xfc, 0x80, 0x51,
    0xcb, 0x47, 0xb4, 0x10, 0xe8, 0xb7, 0xa6, 0x19,
    0xe7, 0x3b, 0x13, 0x50, 0xa9, 0xf6, 0xa2, 0x60,
    0xc5, 0xf1, 0x68, 0x41, 0xe7, 0xc4, 0xdb, 0x53,
    0xd8, 0xea, 0xa0, 0xb4, 0x70, 0x8d, 0x62, 0xf9,
    0x5b, 0x2a, 0x72, 0xe2, 0xf0, 0x4c, 0xa1, 0x46,
    0x47, 0xbc, 0xa6, 0xb5, 0xe3, 0xee, 0x70, 0x7f,
    0xcd, 0xf7, 0x58, 0xb9, 0x25, 0xeb, 0x8d, 0x4e,
    0x6a, 0xce, 0x4f, 0xc7, 0x44, 0x3c, 0x9b, 0xc5,
    0x81, 0x9f, 0xf9, 0xe5, 0x55, 0xbe, 0x09, 0x8a,
    0xa0, 0x55, 0x06, 0x68, 0x28, 0xe2, 0x1b, 0x81,
    0x8f, 0xed, 0xc3, 0xaa, 0xc5, 0x17, 0xa0, 0xee,
    0x8f, 0x90, 0x60, 0xbd, 0x86, 0xe0, 0xd4, 0xcc,
    0xe2, 0x12, 0xab, 0x6a, 0x3a, 0x24, 0x3c, 0x5e,
    0xc0, 0x27, 0x45, 0x63, 0x35, 0x3c, 0xa7, 0x10,
    0x3a, 0xf0, 0x85, 0xe8, 0xf4, 0x1b, 0xe5, 0x24,
    0xfb, 0xb7, 0x5c, 0xda, 0x88, 0x90, 0x39, 0x07,
    0xdf, 0x94, 0xbf, 0xd6, 0x93, 0x73, 0xe2, 0x88,
    0x94, 0x9b, 0xd0, 0x62, 0x6d, 0x85, 0xc1, 0x39,
    0x8b, 0x30, 0x73, 0xa1, 0x39, 0xd5, 0xc7, 0x47,
    0xd2, 0x4a, 0xfd, 0xae, 0x7a, 0x3e, 0x74, 0x54,
    0x37, 0x33, 0x5d, 0x0e, 0xe9, 0x93, 0xee, 0xf3,
    0x6a, 0x30, 0x41, 0xc9, 0x12, 0xf7, 0xeb, 0x58
};

uint8_t DSS_3072_256_msg[] =
{
    0x49, 0x41, 0x80, 0xee, 0xd0, 0x95, 0x13, 0x71,
    0xbb, 0xaf, 0x0a, 0x85, 0x0e, 0xf1, 0x36, 0x79,
    0xdf, 0x49, 0xc1, 0xf1, 0x3f, 0xe3, 0x77, 0x0b,
    0x6c, 0x13, 0x28, 0x5b, 0xf3, 0xad, 0x93, 0xdc,
    0x4a, 0xb0, 0x18, 0xaa, 0xb9, 0x13, 0x9d, 0x74,
    0x20, 0x08, 0x08, 0xe9, 0xc5, 0x5b, 0xf8, 0x83,
    0x00, 0x32, 0x4c, 0xc6, 0x97, 0xef, 0xea, 0xa6,
    0x41, 0xd3, 0x7f, 0x3a, 0xcf, 0x72, 0xd8, 0xc9,
    0x7b, 0xff, 0x01, 0x82, 0xa3, 0x5b, 0x94, 0x01,
    0x50, 0xc9, 0x8a, 0x03, 0xef, 0x41, 0xa3, 0xe1,
    0x48, 0x74, 0x40, 0xc9, 0x23, 0xa9, 0x88, 0xe5,
    0x3c, 0xa3, 0xce, 0x88, 0x3a, 0x2f, 0xb5, 0x32,
    0xbb, 0x74, 0x41, 0xc1, 0x22, 0xf1, 0xdc, 0x2f,
    0x9d, 0x0b, 0x0b, 0xc0, 0x7f, 0x26, 0xba, 0x29,
    0xa3, 0x5c, 0xdf, 0x0d, 0xa8, 0x46, 0xa9, 0xd8,
    0xea, 0xb4, 0x05, 0xcb, 0xf8, 0xc8, 0xe7, 0x7f
};

uint8_t DSS_3072_256_hash[] =
{
    0x43, 0XA6, 0XE9, 0X2E, 0x95, 0x15, 0x85, 0X4D,
    0XD2, 0X8D, 0XD7, 0x78, 0x60, 0X6E, 0x01, 0X9C,
    0x07, 0XD4, 0X7F, 0X8B, 0XBA, 0X4E, 0XBC, 0x02,
    0x03, 0x39, 0x92, 0x07, 0X4A, 0XBA, 0XE9, 0X8A
};

uint8_t DSS_3072_256_k[] =
{
    0xb5, 0x99, 0x11, 0x1b, 0x9f, 0x78, 0x40, 0x2c,
    0xef, 0xe7, 0xbd, 0xe8, 0xbf, 0x55, 0x3b, 0x6c,
    0xa0, 0x0d, 0x5a, 0xba, 0xf9, 0xa1, 0x58, 0xaa,
    0x42, 0xf2, 0x60, 0x7b, 0xf7, 0x85, 0x10, 0xbc
};

uint8_t DSS_3072_256_r[] =
{
    0xa4, 0x0a, 0x6c, 0x90, 0x56, 0x54, 0xc5, 0x5f,
    0xc5, 0x8e, 0x99, 0xc7, 0xd1, 0xa3, 0xfe, 0xea,
    0x2c, 0x5b, 0xe6, 0x48, 0x23, 0xd4, 0x08, 0x6c,
    0xe8, 0x11, 0xf3, 0x34, 0xcf, 0xdc, 0x44, 0x8d
};

uint8_t DSS_3072_256_s[] =
{
    0x64, 0x78, 0x05, 0x09, 0x77, 0xec, 0x58, 0x59,
    0x80, 0x45, 0x4e, 0x0a, 0x2f, 0x26, 0xa0, 0x30,
    0x37, 0xb9, 0x21, 0xca, 0x58, 0x8a, 0x78, 0xa4,
    0xda, 0xff, 0x7e, 0x84, 0xd4, 0x9a, 0x8a, 0x6c
};



static uint8_t P256_x1[] =
{
    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0xF8, 0xF7, 0xF6, 0xF5, 0xF4, 0xF3, 0xF2, 0xF1,
    0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
    0xE8, 0xE7, 0xE6, 0xE5, 0xE4, 0xE3, 0xE2, 0xE3
};

static uint8_t P256_x2[] =
{
    0xFF, 0xEE, 0xDD, 0xCC, 0xBB, 0xAA, 0x99, 0x88,
    0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88,
    0xE8, 0xE7, 0xE6, 0xE5, 0xE4, 0xE3, 0xE2, 0xE1,
    0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x1D
};

static uint8_t P256_x3[] =
{
    0xF8, 0xF7, 0xF6, 0xF5, 0xF4, 0xF3, 0xF2, 0xF1,
    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0xE8, 0xE7, 0xE6, 0xE5, 0xE4, 0xE3, 0xE2, 0xE2
};



// Arithmetic operations tested using an online calculator,
// link:       https://defuse.ca/big-number-calculator.htm
// v1 : 0x0154FD3836AF92D0DCA57D05341D3053
// v2 : 0x017705A70302901DCEB605A9A10E3006

//0x01 54 FD 38 36 AF 92 D0 DC A5 7D 05 34 1D 30 53
static uint8_t ADD_VALUE[] =
{
    0x01, 0x54, 0xFD, 0x38, 0x36, 0xAF, 0x92, 0xD0,
    0xDC, 0xA5, 0x7D, 0x05, 0x34, 0x1D, 0x30, 0x53
};

//0x01 77 05 A7 03 02 90 1D CE B6 05 A9 A1 0E 30 06
static uint8_t ADD_ADDEND[] =
{
    0x01, 0x77, 0x05, 0xA7, 0x03, 0x02, 0x90, 0x1D,
    0xCE, 0xB6, 0x05, 0xA9, 0xA1, 0x0E, 0x30, 0x06
};

//0x02 CC 02 DF 39 B2 22 EE AB 5B 82 AE D5 2B 60 59
static uint8_t ADD_EXPECTED_RES[] =
{
    0x02, 0xCC, 0x02, 0xDF, 0x39, 0xB2, 0x22, 0xEE,
    0xAB, 0x5B, 0x82, 0xAE, 0xD5, 0x2B, 0x60, 0x59
};

//0x01 77 05 A7 03 02 90 1D CE B6 05 A9 A1 0E 30 06
// 1947225966033271952922908856249364486
static uint8_t SUB_VALUE[] =
{
    0x01, 0x77, 0x05, 0xA7, 0x03, 0x02, 0x90, 0x1D,
    0xCE, 0xB6, 0x05, 0xA9, 0xA1, 0x0E, 0x30, 0x06
};

//0x01 54 FD 38 36 AF 92 D0 DC A5 7D 05 34 1D 30 53
// 1770516835233111932234244282275147859
static uint8_t SUB_SUBTRAHEND[] =
{
    0x01, 0x54, 0xFD, 0x38, 0x36, 0xAF, 0x92, 0xD0,
    0xDC, 0xA5, 0x7D, 0x05, 0x34, 0x1D, 0x30, 0x53
};

//0x22 08 6E CC 52 FD 4C F2 10 88 A4 6C F0 FF B3
static uint8_t SUB_EXPECTED_RES[] =
{
    0x00, 0x22, 0x08, 0x6E, 0xCC, 0x52, 0xFD, 0x4C,
    0xF2, 0x10, 0x88, 0xA4, 0x6C, 0xF0, 0xFF, 0xB3,
};

//0x01 54 FD 38 36 AF 92 D0 DC A5 7D 05 34 1D 30 53
static uint8_t MUL_VALUE[] =
{
    0x01, 0x54, 0xFD, 0x38, 0x36, 0xAF, 0x92, 0xD0,
    0xDC, 0xA5, 0x7D, 0x05, 0x34, 0x1D, 0x30, 0x53
};

//0x01 77 05 A7 03 02 90 1D CE B6 05 A9 A1 0E 30 06
static uint8_t MUL_MULTIPLIER[] =
{
    0x01, 0x77, 0x05, 0xA7, 0x03, 0x02, 0x90, 0x1D,
    0xCE, 0xB6, 0x05, 0xA9, 0xA1, 0x0E, 0x30, 0x06
};

//0x00 01 F3 86 74 BF 66 4E C3 92 31 68 A7 91 B8 FD
//  9E 09 E6 CB 38 4B 14 6F 6D 99 A2 AC 89 48 B1 F2
static uint8_t MUL_EXPECTED_RES[] =
{
    0x00, 0x01, 0xF3, 0x86, 0x74, 0xBF, 0x66, 0x4E,
    0xC3, 0x92, 0x31, 0x68, 0xA7, 0x91, 0xB8, 0xFD,
    0x9E, 0x09, 0xE6, 0xCB, 0x38, 0x4B, 0x14, 0x6F,
    0x6D, 0x99, 0xA2, 0xAC, 0x89, 0x48, 0xB1, 0xF2
};

//0x01 54 FD 38 36 AF 92 D0 DC A5 7D 05 34 1D 30 53
static uint8_t MOD_VALUE[] =
{
    0x01, 0x54, 0xFD, 0x38, 0x36, 0xAF, 0x92, 0xD0,
    0xDC, 0xA5, 0x7D, 0x05, 0x34, 0x1D, 0x30, 0x53
};

//0xCE B6 05 A9 A1 0E 30 06
static uint8_t MOD_MODULUS[] =
{
    0xCE, 0xB6, 0x05, 0xA9, 0xA1, 0x0E, 0x30, 0x06
};

//0x54 E6 92 7A 58 DC A9 5B
static uint8_t MOD_EXPECTED_RES[] =
{
    0x54, 0xE6, 0x92, 0x7A, 0x58, 0xDC, 0xA9, 0x5B
};

// converter : www.mobilefish.com/services/big_number/big_number.php
// Calculator : http://planetcalc.com/3311/
//0x02 5E C7 0D F3 19 AD
// 667158978959789
static uint8_t MOD_INV_MODULUS[] =
{
    0x00, 0x02, 0x5E, 0xC7, 0x0D, 0xF3, 0x19, 0xAD
};

//0x0E CC 3D E6
// 248266214
static uint8_t MOD_INV_VALUE[] =
{
    0x00, 0x00, 0x00, 0x00, 0x0E, 0xCC, 0x3D, 0xE6
};

//0x01 63 06 22 18 4B 6A
// 390352969681770
static uint8_t MOD_INV_EXPECTED_RES[] =
{
    0x00, 0x01, 0x63, 0x06, 0x22, 0x18, 0x4B, 0x6A
};

//0x5B 05 4A B3 8C BD 43 0F
static uint8_t SHIFT_VALUE[] =
{
    0x5B, 0x05, 0x4A, 0xB3, 0x8C, 0xBD, 0x43, 0x0F
};

static uint8_t SHIFT_VALUE_R1[] =
{
    0x00, 0x5B, 0x05, 0x4A, 0xB3, 0x8C, 0xBD, 0x43
};

static uint8_t SHIFT_VALUE_R2[] =
{
    0x00, 0x00, 0x5B, 0x05, 0x4A, 0xB3, 0x8C, 0xBD
};

static uint8_t SHIFT_VALUE_R3[] =
{
    0x00, 0x00, 0x00, 0x5B, 0x05, 0x4A, 0xB3, 0x8C
};

static uint8_t SHIFT_VALUE_L1[] =
{
    0x5B, 0x05, 0x4A, 0xB3, 0x8C, 0xBD, 0x43, 0x0F,
    0x00
};

static uint8_t SHIFT_VALUE_L2[] =
{
    0x5B, 0x05, 0x4A, 0xB3, 0x8C, 0xBD, 0x43, 0x0F,
    0x00, 0x00
};

static uint8_t SHIFT_VALUE_L3[] =
{
    0x5B, 0x05, 0x4A, 0xB3, 0x8C, 0xBD, 0x43, 0x0F,
    0x00, 0x00, 0x00
};

// Calculator :
// https://www.mtholyoke.edu/courses/quenell/s2003/ma139/js/powermod.html
//0x0E BB 1E 11 EE FE 01 CA 01
static uint8_t MOD_EXP_MODULUS[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E,
    0xBB, 0x1E, 0x11, 0xEE, 0xFE, 0x01, 0xCA, 0x01
};

//0x01 FF 02 05 91 60
static uint8_t MOD_EXP_EXPONENT[] =
{
    0x00, 0x00, 0x01, 0xFF, 0x02, 0x05, 0x91, 0x60
};

//0x41 F4 E0 AB AF 72
static uint8_t MOD_EXP_VALUE[] =
{
    0x00, 0x00, 0x41, 0xF4, 0xE0, 0xAB, 0xAF, 0x72
};

//0x0D 1C 37 05 41 42 B7 37 14
static uint8_t MOD_EXP_EXPECTED_RES[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D,
    0x1C, 0x37, 0x05, 0x41, 0x42, 0xB7, 0x37, 0x14
};

#endif // PKA_TEST_VECTORS_H
