SUMMARY = "Mellanox BlueField-3 pin control kernel module"
LICENSE = "GPLv2 | BSD-3-Clause"
LIC_FILES_CHKSUM = "file://COPYING;md5=f9a07a5c4b237896cbcb302428226784"

inherit module

do_cve_check[depends] += "${PN}:do_prepare_recipe_sysroot"

SRC_URI = "file://Makefile \
           file://pinctrl-mlxbf3.c \
           file://COPYING \
          "

OOT_KERNEL_MODULES = "pinctrl-mlxbf3"

export INSTALL_MOD_DIR="updates"

# All of the kernel modules listed in OOT_KERNEL_MODULES will be
# contained in packages prefixed with oot- (Out Of Tree).
KERNEL_MODULE_PACKAGE_PREFIX = "oot-"

python do_unpack_append() {
    import shutil
    info = {}

    info['workdir'] = d.getVar('WORKDIR')
    info['s'] = d.getVar('S')
    info['sources'] = d.getVar('SRC_URI').replace("file://", " ")

    for files in info['sources'].split():
      filename = info['workdir'] + '/' + files
      shutil.copy(filename, info['s'])
}

PROVIDES_${PN} =+ " pinctrl-mlxbf3"
