/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2019-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef NETDEV_DOCA_VDPA_H
#define NETDEV_DOCA_VDPA_H 1

#include "netdev.h"

struct netdev_doca_vdpa_relay;
struct ovs_mutex;

/*
 * Functions that implement the HW VDPA for the netdev dpdkvdpa
 * which is defined and implemented in netdev-doca.
 * HW VDPA mode offloads all packet forwarding to hardware.
 */

void *
netdev_doca_vdpa_alloc_relay(void);
int
netdev_doca_vdpa_config_impl(struct netdev_doca_vdpa_relay *relay,
                             const char *vm_socket,
                             const char *vf_devargs);
void
netdev_doca_vdpa_destruct_impl(struct netdev_doca_vdpa_relay *relay);
int
netdev_doca_vdpa_get_custom_stats_impl(struct netdev_doca_vdpa_relay *relay,
                                       struct netdev_custom_stats *cstm_stats,
                                       struct ovs_mutex *dev_mutex,
                                       const struct netdev *netdev,
                                       int (*cb)(const struct netdev *,
                                                 struct netdev_custom_stats *));

#endif /* netdev-doca-vdpa.h */
