EXTRA_DIST += \
	debian/README.Debian \
	debian/changelog \
	debian/changelog.in \
	debian/clean \
	debian/control \
	debian/copyright.in \
	debian/dirs \
	debian/gbp.conf \
	debian/ifupdown.sh \
	debian/ltmain-whole-archive.diff \
	debian/not-installed \
	debian/doca-openvswitch-common.dirs \
	debian/doca-openvswitch-common.install \
	debian/doca-openvswitch-common.lintian-overrides \
	debian/doca-openvswitch-dev.install \
	debian/doca-openvswitch-doc.doc-base \
	debian/doca-openvswitch-doc.install \
	debian/doca-openvswitch-ipsec.openvswitch-ipsec.init \
	debian/doca-openvswitch-ipsec.install \
	debian/doca-openvswitch-ipsec.openvswitch-ipsec.service \
	debian/doca-openvswitch-pki.dirs \
	debian/doca-openvswitch-pki.postinst \
	debian/doca-openvswitch-pki.postrm \
	debian/doca-openvswitch-source.dirs \
	debian/doca-openvswitch-source.docs \
	debian/doca-openvswitch-source.install \
	debian/doca-openvswitch-switch-dpdk.README.Debian \
	debian/doca-openvswitch-switch-dpdk.install \
	debian/doca-openvswitch-switch-dpdk.postinst \
	debian/doca-openvswitch-switch-dpdk.prerm \
	debian/doca-openvswitch-switch.README.Debian \
	debian/doca-openvswitch-switch.openvswitch-switch.default \
	debian/doca-openvswitch-switch.dirs \
	debian/doca-openvswitch-switch.openvswitch-switch.init \
	debian/doca-openvswitch-switch.install \
	debian/doca-openvswitch-switch.links \
	debian/doca-openvswitch-switch.lintian-overrides \
	debian/doca-openvswitch-switch.logrotate \
	debian/doca-openvswitch-switch.ovs-record-hostname.service \
	debian/doca-openvswitch-switch.ovs-vswitchd.service \
	debian/doca-openvswitch-switch.ovsdb-server.service \
	debian/doca-openvswitch-switch.ovs-exporter.service \
	debian/doca-openvswitch-switch.ovs-exporter.conf \
	debian/doca-openvswitch-switch.postinst \
	debian/doca-openvswitch-switch.postrm \
	debian/doca-openvswitch-switch.preinst \
	debian/doca-openvswitch-switch.prerm \
	debian/doca-openvswitch-switch.openvswitch-switch.service \
	debian/doca-openvswitch-test.install \
	debian/doca-openvswitch-testcontroller.README.Debian \
	debian/doca-openvswitch-testcontroller.default \
	debian/doca-openvswitch-testcontroller.dirs \
	debian/doca-openvswitch-testcontroller.openvswitch-testcontroller.init \
	debian/doca-openvswitch-testcontroller.install \
	debian/doca-openvswitch-testcontroller.postinst \
	debian/doca-openvswitch-testcontroller.postrm \
	debian/doca-openvswitch-vtep.default \
	debian/doca-openvswitch-vtep.dirs \
	debian/doca-openvswitch-vtep.openvswitch-vtep.init \
	debian/doca-openvswitch-vtep.install \
	debian/ovs-systemd-reload \
	debian/rules \
	debian/source/format \
	debian/source/lintian-overrides \
	debian/tests/control \
	debian/tests/dpdk \
	debian/tests/openflow.py \
	debian/tests/vanilla \
	debian/watch

update_debian_changelog = \
	$(AM_V_GEN)($(ro_shell) && sed -e 's,[@]VERSION[@],$(OVS_DOCA_VERSION_STRING),g') \
	  < $(srcdir)/debian/changelog.in > $(srcdir)/debian/changelog

debian/changelog: debian/changelog.in
	$(update_debian_changelog)

update_deb_copyright = \
	$(AM_V_GEN) \
	{ sed -n -e '/%AUTHORS%/q' -e p < $(srcdir)/debian/copyright.in;   \
	  tail -n +28 $(srcdir)/AUTHORS.rst | sed '1,/^$$/d' |		   \
		sed -n -e '/^$$/q' -e 's/^/  /p';			   \
	  sed -e '1,/%AUTHORS%/d' $(srcdir)/debian/copyright.in;	   \
	} > $(srcdir)/debian/copyright

debian/copyright: AUTHORS.rst debian/copyright.in
	$(update_deb_copyright)

CLEANFILES += debian/copyright


if DPDK_NETDEV
DEB_BUILD_OPTIONS ?= nocheck parallel=`nproc`
else
DEB_BUILD_OPTIONS ?= nocheck parallel=`nproc` nodpdk
endif

debian: debian/changelog debian/copyright
.PHONY: debian


debian-deb: debian
	@if test X"$(srcdir)" != X"$(top_builddir)"; then			\
		echo "Debian packages should be built from $(abs_srcdir)/";	\
		exit 1;								\
	fi
	$(MAKE) distclean
	$(update_debian_changelog)
	$(update_deb_copyright)
	$(AM_V_GEN) fakeroot debian/rules clean
	$(AM_V_GEN) DEB_BUILD_OPTIONS="$(DEB_BUILD_OPTIONS)" \
		fakeroot debian/rules binary
