/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2024-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef NDU
#define NDU

#include "openflow/openflow.h"
#include "ovsdb-idl.h"

#define NDU_PIDFILE_SUFFIX "upgrading"

void
ndu_init(const char *remote,
         struct ovsdb_idl *idl,
         const char *pidfile);

void
ndu_destroy(void);

void
ndu_run(void);

void
ndu_wait(void);

bool
ndu_done(void);

int
ndu_client_run(void);

int
ndu_connect_and_sync(long int pid);

ofp_port_t
ndu_ofport_number_get(const char *name);

#endif /* NDU */
