# Copyright (C) 2009, 2010, 2011, 2012, 2014 Nicira, Inc.
#
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without warranty of any kind.

EXTRA_DIST += \
	rhel/README.RHEL.rst \
	rhel/automake.mk \
	rhel/etc_init.d_openvswitch \
	rhel/etc_logrotate.d_openvswitch \
	rhel/etc_openvswitch_default.conf \
	rhel/etc_openvswitch_ovs-exporter.conf \
	rhel/etc_sysconfig_network-scripts_ifdown-ovs \
	rhel/etc_sysconfig_network-scripts_ifup-ovs \
	rhel/openvswitch.spec \
	rhel/openvswitch.spec.in \
	rhel/openvswitch-fedora.spec \
	rhel/openvswitch-fedora.spec.in \
	rhel/doca-openvswitch.spec \
	rhel/doca-openvswitch.spec.in \
	rhel/usr_share_openvswitch_scripts_ovs-systemd-reload \
	rhel/usr_share_openvswitch_scripts_sysconfig.template \
	rhel/usr_share_openvswitch_scripts_systemd_sysconfig.template \
	rhel/usr_lib_udev_rules.d_91-vfio.rules \
	rhel/usr_lib_systemd_system_openvswitch.service \
	rhel/usr_lib_systemd_system_ovsdb-server.service \
	rhel/usr_lib_systemd_system_ovs-vswitchd.service.in \
	rhel/usr_lib_systemd_system_ovs-exporter.service \
	rhel/usr_lib_systemd_system_ovs-delete-transient-ports.service \
	rhel/usr_lib_systemd_system_openvswitch-ipsec.service

DISTCLEANFILES += rhel/usr_lib_systemd_system_ovs-vswitchd.service

update_rhel_spec = \
  $(AM_V_GEN)($(ro_shell) && sed -e 's,[@]VERSION[@],$(OVS_DOCA_VERSION_STRING),g') \
    < $(srcdir)/rhel/$(@F).in > $(@F).tmp || exit 1; \
  if cmp -s $(@F).tmp $@; then touch $@; rm $(@F).tmp; else mv $(@F).tmp $@; fi

$(srcdir)/rhel/openvswitch.spec: rhel/openvswitch.spec.in $(top_builddir)/config.status
	$(update_rhel_spec)

$(srcdir)/rhel/openvswitch-fedora.spec: rhel/openvswitch-fedora.spec.in $(top_builddir)/config.status
	$(update_rhel_spec)

$(srcdir)/rhel/doca-openvswitch.spec: rhel/doca-openvswitch.spec.in $(top_builddir)/config.status
	$(update_rhel_spec)

RPMBUILD_TOP := $(abs_top_builddir)/rpm/rpmbuild
RPMBUILD_OPT ?= --without check

# Build user-space RPMs
dist-rename: dist
	mkdir tempdir
	tar -xzf $(PACKAGE)-$(VERSION).tar.gz -C tempdir
	tar -czf $(PACKAGE)-$(OVS_DOCA_VERSION_STRING).tar.gz \
	    --transform='s/$(PACKAGE)-$(VERSION)/$(PACKAGE)-$(OVS_DOCA_VERSION_STRING)/' \
	    -C tempdir .
	rm -rf tempdir

rpm-fedora: dist-rename $(srcdir)/rhel/doca-openvswitch.spec
	${MKDIR_P} ${RPMBUILD_TOP}/SOURCES
	cp $(PACKAGE)-$(OVS_DOCA_VERSION_STRING).tar.gz ${RPMBUILD_TOP}/SOURCES
	rpmbuild ${RPMBUILD_OPT} \
                 -D "_topdir ${RPMBUILD_TOP}" \
                 -ba $(srcdir)/rhel/doca-openvswitch.spec

