/* SPDX-License-Identifier: GPL-2.0 or BSD-3-Clause */

/*
 * Copyright (c) 2020 NVIDIA Corporation.
 */

#ifndef __BLUEFIELD_EDAC_REGS_H__
#define __BLUEFIELD_EDAC_REGS_H__

#ifdef __ASSEMBLER__
#define _64bit(x) x
#else /* __ASSEMBLER__ */
#define _64bit(x) x ## ULL
#endif /* __ASSEMBLER */

#include <linux/types.h>

#define EMI_DRAM_ECC_COUNT 0x0340
#define EMI_DRAM_ECC_COUNT__LENGTH 0x0001

#define EMI_DRAM_ECC_COUNT__SINGLE_ERROR_COUNT_SHIFT 0
#define EMI_DRAM_ECC_COUNT__SINGLE_ERROR_COUNT_WIDTH 16
#define EMI_DRAM_ECC_COUNT__SINGLE_ERROR_COUNT_RESET_VAL 0
#define EMI_DRAM_ECC_COUNT__SINGLE_ERROR_COUNT_RMASK 0xffff
#define EMI_DRAM_ECC_COUNT__SINGLE_ERROR_COUNT_MASK  0xffff

#define EMI_DRAM_ECC_COUNT__DOUBLE_ERROR_COUNT_SHIFT 16
#define EMI_DRAM_ECC_COUNT__DOUBLE_ERROR_COUNT_WIDTH 16
#define EMI_DRAM_ECC_COUNT__DOUBLE_ERROR_COUNT_RESET_VAL 0
#define EMI_DRAM_ECC_COUNT__DOUBLE_ERROR_COUNT_RMASK 0xffff
#define EMI_DRAM_ECC_COUNT__DOUBLE_ERROR_COUNT_MASK  0xffff0000

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* ECC single errors counter */
		u32 single_error_count : 16;
		/* ECC double errors counter */
		u32 double_error_count : 16;
	};

	u32 word;
} EMI_DRAM_ECC_COUNT_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ECC_ERROR 0x0348
#define EMI_DRAM_ECC_ERROR__LENGTH 0x0001

#define EMI_DRAM_ECC_ERROR__DRAM_ECC_SINGLE_SHIFT 0
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_SINGLE_WIDTH 1
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_SINGLE_RESET_VAL 0
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_SINGLE_RMASK 0x1
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_SINGLE_MASK  0x1

#define EMI_DRAM_ECC_ERROR__DRAM_ECC_DOUBLE_SHIFT 16
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_DOUBLE_WIDTH 1
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_DOUBLE_RESET_VAL 0
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_DOUBLE_RMASK 0x1
#define EMI_DRAM_ECC_ERROR__DRAM_ECC_DOUBLE_MASK  0x10000

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* 1 - ECC single error from DRAM wrapper x. */
		u32 dram_ecc_single : 1;
		/* Reserved. */
		u32 __reserved_0    : 15;
		/* 1 - ECC double error from DRAM wrapper x. */
		u32 dram_ecc_double : 1;
		/* Reserved. */
		u32 __reserved_1    : 15;
	};

	u32 word;
} EMI_DRAM_ECC_ERROR_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ECC_LATCH_SELECT 0x0354
#define EMI_DRAM_ECC_LATCH_SELECT__LENGTH 0x0001

#define EMI_DRAM_ECC_LATCH_SELECT__DRAM_ECC_FIRST_SHIFT 0
#define EMI_DRAM_ECC_LATCH_SELECT__DRAM_ECC_FIRST_WIDTH 1
#define EMI_DRAM_ECC_LATCH_SELECT__DRAM_ECC_FIRST_RESET_VAL 1
#define EMI_DRAM_ECC_LATCH_SELECT__DRAM_ECC_FIRST_RMASK 0x1
#define EMI_DRAM_ECC_LATCH_SELECT__DRAM_ECC_FIRST_MASK  0x1

#define EMI_DRAM_ECC_LATCH_SELECT__EDGE_SEL_SHIFT 16
#define EMI_DRAM_ECC_LATCH_SELECT__EDGE_SEL_WIDTH 4
#define EMI_DRAM_ECC_LATCH_SELECT__EDGE_SEL_RESET_VAL 0
#define EMI_DRAM_ECC_LATCH_SELECT__EDGE_SEL_RMASK 0xf
#define EMI_DRAM_ECC_LATCH_SELECT__EDGE_SEL_MASK  0xf0000

#define EMI_DRAM_ECC_LATCH_SELECT__START_SHIFT 24
#define EMI_DRAM_ECC_LATCH_SELECT__START_WIDTH 1
#define EMI_DRAM_ECC_LATCH_SELECT__START_RESET_VAL 0
#define EMI_DRAM_ECC_LATCH_SELECT__START_RMASK 0x1
#define EMI_DRAM_ECC_LATCH_SELECT__START_MASK  0x1000000

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/*
		 * For DRAM wrapper x.
		 *
		 * 0 - Last ECC error will be stored.
		 *
		 * 1 - First ECC error will be stored.
		 */
		u32 dram_ecc_first : 1;
		/* Reserved. */
		u32 __reserved_0   : 15;
		/* Selects to Edge (one of 8) to get the ECC info. */
		u32 edge_sel       : 4;
		/* Reserved. */
		u32 __reserved_1   : 4;
		/* 1 - Start select DRAM_INFO */
		u32 start          : 1;
		/* Reserved. */
		u32 __reserved_2   : 7;
	};

	u32 word;
} EMI_DRAM_ECC_LATCH_SELECT_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ERR_ADDR_0 0x0358
#define EMI_DRAM_ERR_ADDR_0__LENGTH 0x0001

#define EMI_DRAM_ERR_ADDR_0__ERROR_ADDR_SHIFT 0
#define EMI_DRAM_ERR_ADDR_0__ERROR_ADDR_WIDTH 32
#define EMI_DRAM_ERR_ADDR_0__ERROR_ADDR_RESET_VAL 0
#define EMI_DRAM_ERR_ADDR_0__ERROR_ADDR_RMASK 0xffffffff
#define EMI_DRAM_ERR_ADDR_0__ERROR_ADDR_MASK  0xffffffff

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Provides the ECC error address */
		u32 error_addr : 32;
	};

	u32 word;
} EMI_DRAM_ERR_ADDR_0_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ERR_ADDR_1 0x037c
#define EMI_DRAM_ERR_ADDR_1__LENGTH 0x0001

#define EMI_DRAM_ERR_ADDR_1__ERROR_ADDR_SHIFT 0
#define EMI_DRAM_ERR_ADDR_1__ERROR_ADDR_WIDTH 32
#define EMI_DRAM_ERR_ADDR_1__ERROR_ADDR_RESET_VAL 0
#define EMI_DRAM_ERR_ADDR_1__ERROR_ADDR_RMASK 0xffffffff
#define EMI_DRAM_ERR_ADDR_1__ERROR_ADDR_MASK  0xffffffff

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Provides the ECC error address */
		u32 error_addr : 32;
	};

	u32 word;
} EMI_DRAM_ERR_ADDR_1_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_SYNDROM 0x035c
#define EMI_DRAM_SYNDROM__LENGTH 0x0001

#define EMI_DRAM_SYNDROM__DERR_SHIFT 0
#define EMI_DRAM_SYNDROM__DERR_WIDTH 1
#define EMI_DRAM_SYNDROM__DERR_RESET_VAL 0
#define EMI_DRAM_SYNDROM__DERR_RMASK 0x1
#define EMI_DRAM_SYNDROM__DERR_MASK  0x1

#define EMI_DRAM_SYNDROM__SERR_SHIFT 1
#define EMI_DRAM_SYNDROM__SERR_WIDTH 1
#define EMI_DRAM_SYNDROM__SERR_RESET_VAL 0
#define EMI_DRAM_SYNDROM__SERR_RMASK 0x1
#define EMI_DRAM_SYNDROM__SERR_MASK  0x2

#define EMI_DRAM_SYNDROM__SYNDROM_SHIFT 16
#define EMI_DRAM_SYNDROM__SYNDROM_WIDTH 10
#define EMI_DRAM_SYNDROM__SYNDROM_RESET_VAL 0
#define EMI_DRAM_SYNDROM__SYNDROM_RMASK 0x3ff
#define EMI_DRAM_SYNDROM__SYNDROM_MASK  0x3ff0000

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* 1 - Double error. */
		u32 derr         : 1;
		/* 1 - Single error. */
		u32 serr         : 1;
		/* Reserved. */
		u32 __reserved_0 : 14;
		/* ECC syndrome (error bit according to the Hamming code). */
		u32 syndrom      : 10;
		/* Reserved. */
		u32 __reserved_1 : 6;
	};

	u32 word;
} EMI_DRAM_SYNDROM_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ADDITIONAL_INFO_0 0x0364
#define EMI_DRAM_ADDITIONAL_INFO_0__LENGTH 0x0001

#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_BANK_SHIFT 0
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_BANK_WIDTH 4
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_BANK_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_BANK_RMASK 0xf
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_BANK_MASK  0xf

#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_LRANK_SHIFT 4
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_LRANK_WIDTH 2
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_LRANK_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_LRANK_RMASK 0x3
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_LRANK_MASK  0x30

#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_PRANK_SHIFT 8
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_PRANK_WIDTH 2
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_PRANK_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_PRANK_RMASK 0x3
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_PRANK_MASK  0x300

#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_EDGE_SHIFT 16
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_EDGE_WIDTH 8
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_EDGE_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_EDGE_RMASK 0xff
#define EMI_DRAM_ADDITIONAL_INFO_0__ERR_EDGE_MASK  0xff0000

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Physical Error Bank. */
		u32 err_bank     : 4;
		/* Physical Error Logical Rank. */
		u32 err_lrank    : 2;
		/* Reserved. */
		u32 __reserved_0 : 2;
		/* Physical Error Physical Rank. */
		u32 err_prank    : 2;
		/* Reserved. */
		u32 __reserved_1 : 6;
		/* Error Edge Bitmap. */
		u32 err_edge     : 8;
		/* Reserved. */
		u32 __reserved_2 : 8;
	};

	u32 word;
} EMI_DRAM_ADDITIONAL_INFO_0_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ADDITIONAL_INFO_1 0x0368
#define EMI_DRAM_ADDITIONAL_INFO_1__LENGTH 0x0001

#define EMI_DRAM_ADDITIONAL_INFO_1__ERR_ADDR_SHIFT 0
#define EMI_DRAM_ADDITIONAL_INFO_1__ERR_ADDR_WIDTH 25
#define EMI_DRAM_ADDITIONAL_INFO_1__ERR_ADDR_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_1__ERR_ADDR_RMASK 0x1ffffff
#define EMI_DRAM_ADDITIONAL_INFO_1__ERR_ADDR_MASK  0x1ffffff

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Physical Error Address (Row + Col). */
		u32 err_addr   : 25;
		/* Reserved. */
		u32 __reserved : 7;
	};

	u32 word;
} EMI_DRAM_ADDITIONAL_INFO_1_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ADDITIONAL_INFO_2 0x036c
#define EMI_DRAM_ADDITIONAL_INFO_2__LENGTH 0x0001

#define EMI_DRAM_ADDITIONAL_INFO_2__ERR_STREAM_ID_SHIFT 0
#define EMI_DRAM_ADDITIONAL_INFO_2__ERR_STREAM_ID_WIDTH 8
#define EMI_DRAM_ADDITIONAL_INFO_2__ERR_STREAM_ID_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_2__ERR_STREAM_ID_RMASK 0xff
#define EMI_DRAM_ADDITIONAL_INFO_2__ERR_STREAM_ID_MASK  0xff

#define EMI_DRAM_ADDITIONAL_INFO_2__HOST_ACCESS_SHIFT 16
#define EMI_DRAM_ADDITIONAL_INFO_2__HOST_ACCESS_WIDTH 1
#define EMI_DRAM_ADDITIONAL_INFO_2__HOST_ACCESS_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_2__HOST_ACCESS_RMASK 0x1
#define EMI_DRAM_ADDITIONAL_INFO_2__HOST_ACCESS_MASK  0x10000

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Error Transaction Stream ID. */
		u32 err_stream_id : 8;
		/* Reserved. */
		u32 __reserved_0  : 8;
		/* Host Access Indication */
		u32 host_access   : 1;
		/* Reserved. */
		u32 __reserved_1  : 15;
	};

	u32 word;
} EMI_DRAM_ADDITIONAL_INFO_2_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ADDITIONAL_INFO_3 0x0370
#define EMI_DRAM_ADDITIONAL_INFO_3__LENGTH 0x0001

#define EMI_DRAM_ADDITIONAL_INFO_3__ERR_USR_FREE_SHIFT 0
#define EMI_DRAM_ADDITIONAL_INFO_3__ERR_USR_FREE_WIDTH 32
#define EMI_DRAM_ADDITIONAL_INFO_3__ERR_USR_FREE_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_3__ERR_USR_FREE_RMASK 0xffffffff
#define EMI_DRAM_ADDITIONAL_INFO_3__ERR_USR_FREE_MASK  0xffffffff

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Error Transaction User Free bits. */
		u32 err_usr_free : 32;
	};

	u32 word;
} EMI_DRAM_ADDITIONAL_INFO_3_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ADDITIONAL_INFO_4 0x0374
#define EMI_DRAM_ADDITIONAL_INFO_4__LENGTH 0x0001

#define EMI_DRAM_ADDITIONAL_INFO_4__VAL_SHIFT 0
#define EMI_DRAM_ADDITIONAL_INFO_4__VAL_WIDTH 32
#define EMI_DRAM_ADDITIONAL_INFO_4__VAL_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_4__VAL_RMASK 0xffffffff
#define EMI_DRAM_ADDITIONAL_INFO_4__VAL_MASK  0xffffffff

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Error Transaction Data. */
		u32 val : 32;
	};

	u32 word;
} EMI_DRAM_ADDITIONAL_INFO_4_t;
#endif /* !defined(__ASSEMBLER__) */

#define EMI_DRAM_ADDITIONAL_INFO_5 0x0378
#define EMI_DRAM_ADDITIONAL_INFO_5__LENGTH 0x0001

#define EMI_DRAM_ADDITIONAL_INFO_5__VAL_SHIFT 0
#define EMI_DRAM_ADDITIONAL_INFO_5__VAL_WIDTH 32
#define EMI_DRAM_ADDITIONAL_INFO_5__VAL_RESET_VAL 0
#define EMI_DRAM_ADDITIONAL_INFO_5__VAL_RMASK 0xffffffff
#define EMI_DRAM_ADDITIONAL_INFO_5__VAL_MASK  0xffffffff

#ifndef __ASSEMBLER__
__extension__
typedef union {
	struct {
		/* Error Transaction Data. */
		u32 val : 32;
	};

	u32 word;
} EMI_DRAM_ADDITIONAL_INFO_5_t;
#endif /* !defined(__ASSEMBLER__) */

#endif /* !defined(__BLUEFIELD_EDAC_REGS_H__) */
